/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.prescription.gui.widgets.editor.template;

import java.awt.Component;

import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

/**
 * Renderer for the prescription template list
 * 
 * @author martin.heinemann@tudor.lu
 *
 *
 * @version
 * <br>$Log: TemplateCellRenderer.java,v $
 * <br>Revision 1.6  2013-12-27 18:09:25  donak
 * <br>Cleanup of imports
 * <br>
 * <br>Revision 1.5  2008-10-22 15:46:34  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.4  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.3  2008-01-15 13:40:35  heinemann
 * <br>better documentation
 * <br>
 * <br>Revision 1.2  2007/03/02 08:28:39  hermen
 * <br>initial checkin after the merge of PatientModuleRebuild with the main HEAD
 * <br>
 * <br>Revision 1.1.2.1  2006/12/28 10:32:26  heinemann
 * <br>bug fixing and template improvements
 * <br>
 */
public class TemplateCellRenderer extends DefaultTableCellRenderer {


		/**
		 * 
		 */
		private static final long serialVersionUID = 1L;
		private TemplateModel model;

		
		public TemplateCellRenderer(TemplateModel model) {
			this.model = model;
		}
		
		
		/* (non-Javadoc)
		 * @see com.l2fprod.common.swing.renderer.DefaultCellRenderer#getTableCellRendererComponent(javax.swing.JTable, java.lang.Object, boolean, boolean, int, int)
		 */
		@Override
		public Component getTableCellRendererComponent(
				JTable p_Table,
				Object value, boolean p_IsSelected, boolean hasFocus, int row,
				int column) {
			/* ============================================= */
			this.setOpaque(false);
//			if (model.isMarked(model.getTemplateByRow(row))) {
//				/* ------------------------------------------------------ */
//				// we want a red background and a crosslined text
//				if (value instanceof String) {
//					
//					this.setOpaque(true);
//					this.setBackground(new Color(255, 100, 100));
//					String s = "<html><span style=\"text-decoration: line-through;\">" 
////						   + "background-color:#f5c4b1\">"
//						+(String) value +"</span></html>";
//					
//					
//					
//					return super.getTableCellRendererComponent(
//							p_Table,
//							s, p_IsSelected, hasFocus, row,
//							column);
//				}
//				/* ------------------------------------------------------ */
//			}
			
			return super.getTableCellRendererComponent(
					p_Table,
					value, p_IsSelected, hasFocus, row,
					column);
			/* ============================================= */
		}
		
	
}
