/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/**
 * 
 */
package lu.tudor.santec.gecamed.prescription.gui.widgets.editor.template.editor;

import java.util.ArrayList;
import java.util.List;

import lu.tudor.santec.gecamed.core.gui.utils.IChangeListener;
import lu.tudor.santec.gecamed.prescription.ejb.entity.beans.PrescriptionTemplate;

/**
 * The model for the prescription template editor
 * It has only a single prescription template.
 * 
 * 
 * @author martin.heinemann@tudor.lu
 *
 *
 * @version
 * <br>$Log: TemplateEditorModel.java,v $
 * <br>Revision 1.6  2008-09-25 09:43:10  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.5  2008-05-13 11:53:41  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.4  2008-02-11 16:51:50  heinemann
 * <br>moved IChangeListener to core
 * <br>
 * <br>Revision 1.3  2008-01-15 13:40:35  heinemann
 * <br>better documentation
 * <br>
 * <br>Revision 1.2  2007/03/02 08:28:44  hermen
 * <br>initial checkin after the merge of PatientModuleRebuild with the main HEAD
 * <br>
 * <br>Revision 1.1.2.2  2007/01/04 13:51:37  heinemann
 * <br>The great space cleaning lady has done a big bunch of refactoring
 * <br>
 * <br>Revision 1.1.2.1  2006/12/21 14:26:43  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.1.2.1  2006/12/19 14:53:31  heinemann
 * <br>printing etc
 * <br>
 */
public class TemplateEditorModel {

	
	private PrescriptionTemplate template;
	
	private List<IChangeListener> changeListeners;

	private String type;

	private PrescriptionTemplate copyOfTemplate;

	private boolean isModified = false;


	/**
	 * 
	 */
	public TemplateEditorModel() {
		/* ====================================================== */
		this.changeListeners = new ArrayList<IChangeListener>();

		// init the template with an empty one
		this.setTemplate(new PrescriptionTemplate());
		/* ====================================================== */
	}
	
	
	public PrescriptionTemplate getTemplate() {
		/* ====================================================== */
		return this.template;
		/* ====================================================== */
	}
	
	/**
	 * Set the current template
	 * 
	 * @param template
	 */
	public void setTemplate(PrescriptionTemplate template)  {
		/* ====================================================== */
		this.template = template;
		// save a copy for change check
		this.copyOfTemplate = template.copy();
		this.isModified = false;
		this.fireDataChanged();
		/* ====================================================== */
	}
	
	public void setType(String type) {
		/* ====================================================== */
		this.type = type;
		/* ====================================================== */
	}
	
	/**
	 * @return
	 */
	public String getType() {
		/* ====================================================== */
		return this.type;
		/* ====================================================== */
	}
	
	public PrescriptionTemplate getOriginal() {
		/* ====================================================== */
		return copyOfTemplate;
		/* ====================================================== */
	}
	
	
	/**
	 * Notify all ChangeListener
	 */
	public void fireDataChanged() {
		/* ====================================================== */
		Thread t = new Thread() {
			public void run() {
				for (IChangeListener l : changeListeners)
					l.fireEvent();
			}
		};
		t.start();
		/* ====================================================== */
	}
	
	
	/**
	 * Add a changelistener to the model
	 * 
	 * @param listener
	 */
	public void addChangeListener(IChangeListener listener) {
		/* ====================================================== */
		this.changeListeners.add(listener);
		/* ====================================================== */
	}
	
	/* ------------------------------------------------------ */
	/* ------------------------------------------------------ */
	
	/**
	 * Set the shortcut
	 * 
	 * @param shortcut
	 */
	public void setShortcut(String shortcut) {
		/* ====================================================== */
		if (template != null) {
			template.setShortcut(shortcut);
		}
		/* ====================================================== */
	}
	
	/**
	 * Set the description
	 * 
	 * @param description
	 */
	public void setDescription(String description) {
		/* ====================================================== */
		if (template != null)
			template.setDescription(description);
		/* ====================================================== */
	}
	
	/**
	 * @param msg
	 */
	public void setWarningMsg (String msg) {
		/* ====================================================== */
		if (template != null) {
			/* ------------------------------------------------------ */
			template.setWarningMsg(msg);
			/* ------------------------------------------------------ */
		}
		/* ====================================================== */
	}
	
	/**
	 * @param b
	 */
	public void setWarning(Boolean b) {
		/* ====================================================== */
		if (template != null) {
			template.setIsWarning(b);
		}
		/* ====================================================== */
	}
	
	/**
	 * Set the content of the template
	 * 
	 * @param content
	 */
	public void setTextContent(String content) {
		/* ====================================================== */
		if (template != null) {
			template.setTextContent(content);
		}
		/* ====================================================== */
	}


	/**
	 * Reset the model.
	 */
	public void reset() {
		/* ============================================= */
		this.template = new PrescriptionTemplate();
		fireDataChanged();
		/* ============================================= */
	}


	public void setModified(boolean b) {
		/* ============================================= */
		this.isModified = b;
		/* ============================================= */
	}
	
	public boolean isModified() {
		/* ====================================================== */
		return this.isModified;
		/* ====================================================== */
	}
	
}




