/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.prescription.gui.widgets.toolkit.searchbox;

import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

/**
 * Thread class that keeps the gatherer running.
 * 
 * 
 * @author Martin Heinemann martin.heinemann@tudor.lu
 *
 *
 */
public class SearchBoxLookupThread extends Thread implements DocumentListener {



    private ISearchBoxLookUp gatherer;

    private JTextField textField;
//    private SearchBoxPopup popup;
//    private int searchOffset;




    public SearchBoxLookupThread(ISearchBoxLookUp gatherer, JTextField textField, SearchBoxPopup popup, int offset) {
        this.gatherer       = gatherer;
        this.textField      = textField;
//        this.popup          = popup;
//        this.searchOffset   = offset;
        initComponent();
    }


    public void run() {
       doLookUp();
    }

    private void initComponent() {

        // register documentListener
        //this.textField.getDocument().addDocumentListener(this);
    }


    private void doLookUp() {
//        if (textField.getText().length() >= this.searchOffset) {

            gatherer.fireNewSearch(textField.getText());

//            SwingUtilities.invokeLater(new Runnable() {
//                public void run() {
//                  // Wird erst aufgerufen, wenn alle
//                  // Aufgaben abgearbeitet wurden
//                    popup.setNewData(l);
//                }
//              });
//        }
    }


    public void insertUpdate(DocumentEvent e) {
        doLookUp();
    }
    public void removeUpdate(DocumentEvent e) {
        doLookUp();
    }
    public void changedUpdate(DocumentEvent e) {}
}
