/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/*
 * Created on 27.11.2005
 *
 */
package lu.tudor.santec.gecamed.prescription.gui.widgets.toolkit.searchbox.persistence;

import java.util.ArrayList;
import java.util.List;

import lu.tudor.santec.gecamed.prescription.ejb.entity.dataclasses.DrugLight;
import lu.tudor.santec.gecamed.prescription.gui.util.IResultListener;
import lu.tudor.santec.gecamed.prescription.gui.util.NewDrugWorker;
import lu.tudor.santec.gecamed.prescription.gui.widgets.toolkit.searchbox.ISearchBoxLookUp;

import org.apache.log4j.Logger;


/**
 * Class to do the drug lookup for the searchbox-autocompletion
 * 
 * 
 * @author martin.heinemann@tudor.lu
 * 16.01.2008
 * 10:11:52
 *
 *
 * @version
 * <br>$Log: SearchBoxDrugGatherer.java,v $
 * <br>Revision 1.8  2013-12-27 18:09:26  donak
 * <br>Cleanup of imports
 * <br>
 * <br>Revision 1.7  2013-07-15 06:18:37  ferring
 * <br>logging changed
 * <br>
 * <br>Revision 1.6  2008-09-25 09:43:10  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.5  2008-01-16 15:36:57  heinemann
 * <br>better documentation
 * <br>
 *   
 */
public class SearchBoxDrugGatherer implements ISearchBoxLookUp{

	/** the logger Object for this class */
	private static Logger logger = Logger.getLogger(SearchBoxDrugGatherer.class.getName());

    private List<IResultListener> listeners = new ArrayList<IResultListener>();

	public SearchBoxDrugGatherer() {
	    super();

    }

    /* (non-Javadoc)
     * @see lu.tudor.santec.gecamed.prescription.gui.widgets.toolkit.searchbox.ISearchBoxLookUp#fireNewSearch(java.lang.Object)
     */
    public void fireNewSearch(Object object) {
        logger.debug("Enter fireNewSearch");
        if (object instanceof String) {
            String text = (String) object;
            try {
            	/* ------------------------------------------------------- */
                logger.debug("Trying lookup");
                List<DrugLight> list = NewDrugWorker.getDrugsByPattern(text);
                informResultListeners(list);
                /* ------------------------------------------------------- */
            }
            catch (Exception e) {
            	/* ------------------------------------------------------- */
                // TODO: handle exception
                logger.warn("Error during searching for drug pattern");
                return;
                /* ------------------------------------------------------- */
            }
        }
    }

    private void informResultListeners(Object data) {
        for (IResultListener listener : listeners) {
            listener.receiveResult(data);
        }
    }


    public void addResultListener(IResultListener listener) {
        this.listeners.add(listener);
    }

    public void removeResultListener(IResultListener listener) {
        this.listeners.remove(listener);
    }

}
