/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/**
 *
 */
package lu.tudor.santec.gecamed.prescription.tests;

import java.io.FileInputStream;
import java.util.List;
import java.util.Properties;

import junit.framework.TestCase;
import lu.tudor.santec.gecamed.core.gui.LoginScreen;
import lu.tudor.santec.gecamed.core.utils.ManagerFactory;
import lu.tudor.santec.gecamed.prescription.ejb.entity.dataclasses.DrugLight;
import lu.tudor.santec.gecamed.prescription.ejb.session.interfaces.drug.lists.cefip.CefipDrugManager;

/**
 * @author martin.heinemann@tudor.lu
 *
 *
 * @version
 * <br>$Log: TestCefipDrugManagerBean.java,v $
 * <br>Revision 1.6  2013-12-27 18:09:27  donak
 * <br>Cleanup of imports
 * <br>
 * <br>Revision 1.5  2008-09-25 09:43:10  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.4  2007-11-20 08:58:55  hermen
 * <br>moved Managerfactory to core.utils and refactured code to use ManagerFactory instead of context.lookup
 * <br>
 * <br>Revision 1.3  2007-10-03 15:27:47  mack
 * <br>Changes required by renaming settings property to properties in LoginScreen class
 * <br>
 * <br>Revision 1.2  2007/03/02 08:28:45  hermen
 * <br>initial checkin after the merge of PatientModuleRebuild with the main HEAD
 * <br>
 * <br>Revision 1.1.2.2  2007/02/21 10:01:01  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.1.2.1  2007/02/08 16:45:12  heinemann
 * <br>many changes
 * <br>
 */
public class TestCefipDrugManagerBean extends TestCase {

	private CefipDrugManager cefipManager;

	/**
	 * @param arg0
	 */
	public TestCefipDrugManagerBean(String arg0) {
		super(arg0);
	}


	protected void setUp() throws Exception {
		try {
			Properties prop = new Properties();
			prop.load(new FileInputStream( LoginScreen.PROPERTIES_DEFAULT));

			this.cefipManager = (CefipDrugManager)
					ManagerFactory.getRemote(ManagerFactory.CEFIPDRUGMANAGER);
			/* ------------------------------------------------------ */
		} catch (Exception e) {
			e.printStackTrace();
			fail("Could not get reference to Session Bean!");
		}
	}

	protected void tearDown() throws Exception {
		this.cefipManager = null; // let gc do its work har har
	}

	/* #########################################################
	 * Here are the test methods
	 */

	/* ------------------------------------------------------ */
	// getLightDrugsByNamePattern


	/**
	 * Test if the method returns an empty list in case
	 * of no search result
	 */
	public void testGetLightDrugsByNamePatternIfIsEmpty() {
		/* ====================================================== */
		String pattern = "ü&%)(§"; // should lead to en empty result =)
		int limit = 30;
		/* ------------------------------------------------------ */
		try {
			List<DrugLight> result =
				cefipManager.getLightDrugsByNamePattern(pattern, limit);
			// if the result is null
			assertNotNull("Result is null!", result);
			// if the list is empty
			assertEquals(0, result.size());
		} catch (Exception e) {
			e.printStackTrace();
			fail("Something wicked happens during method involation");
		}
		/* ====================================================== */
	}

	/**
	 *
	 */
//	public void testGetLightDrugsByNamePattern() {
//		/* ====================================================== */
//		String pattern = "";
//		int limit = 20000;
//		/* ------------------------------------------------------ */
//		try {
//			long start = System.currentTimeMillis();
//			long memStart = Runtime.getRuntime().freeMemory();
//			System.out.println("Total Mem      : " + Runtime.getRuntime().totalMemory());
//			System.out.println("Free Mem before: " + memStart + " b");
//			List<DrugLight> result =
//				cefipManager.getLightDrugsByNamePattern(pattern, limit);
//			System.out.println("Free Mem after : " + Runtime.getRuntime().freeMemory()+ " b");
//			System.out.println("Used mem: " + (memStart - Runtime.getRuntime().freeMemory())+ " b");
//
//			System.out.println("Fetching " + result.size() +" drugs took "
//					+ (System.currentTimeMillis() - start) + " ms");
//
//
//
//			// if the result is null
//			assertNotNull("Result is null!", result);
//			// if the list is empty
//			assertTrue("Result size is smaller than 1: "+result.size(),
//								result.size() > 0);
//		} catch (Exception e) {
//			e.printStackTrace();
//			fail("Something wicked happens during method involation");
//		}
//		/* ====================================================== */
//	}


	public void testGetAllDrugs() {
		/* ================================================== */
		int start = 0;
		int maxSize = 500;

		try {
			cefipManager.getDrugs(start, maxSize);
		}catch (Exception e) {
			e.printStackTrace();
		}
		/* ================================================== */
	}


}
