package lu.tudor.santec.gecamed.reporting.ejb.entity.beans;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;


@NamedQueries(
{
	@NamedQuery(name = ParameterQuery.GET_QUERY_BY_NAME, 
			query = "SELECT OBJECT(o) FROM ParameterQuery o WHERE name = :name")
})

@Entity
@Table(name = "parameter_query", schema = "reporting")
public class ParameterQuery extends GECAMedEntityBean
{
	/* ======================================== */
	// 		CONSTANTS
	/* ======================================== */
	
	private static final long	serialVersionUID	= 1L;
	
	
	public static final String	GET_QUERY_BY_NAME	= "getQueryByName";
	
	
	
	/* ======================================== */
	// 		MEMBERS
	/* ======================================== */
	
	private String	name;
	
	private String	comment;
	
	private String	query;
	
	
	
	/* ======================================== */
	// 		GETTER & SETTER
	/* ======================================== */
	
	@Column(name = "name")
	public String getName()
	{
		return name;
	}
	
	
	public void setName(String name)
	{
		this.name = name;
	}
	
	
	@Column(name = "comment")
	public String getComment()
	{
		return comment;
	}
	
	
	public void setComment(String comment)
	{
		this.comment = comment;
	}
	
	
	@Column(name = "query")
	public String getQuery()
	{
		return query;
	}
	
	
	public void setQuery(String query)
	{
		this.query = query;
	}
	
	
	@Transient
	@Override
	public String toString()
	{
		return getName();
	}
}
