/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.reporting.gui;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import lu.tudor.santec.gecamed.core.gui.GECAMedAction;
import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.IconFetcher;
import lu.tudor.santec.gecamed.reporting.gui.listing.ReportList;
import lu.tudor.santec.i18n.Translatrix;

public class ReportModule extends GECAMedModule
{
	/* ======================================== */
	// 		CONSTANTS
	/* ======================================== */
	
	private static final long		serialVersionUID	= 1L;
	
	
	/**
	 * The name of the module 
	 */
	public static final String		MODULE_NAME			= "Report";
	
	// permissions
	public static final String PERMISSION_USE		= "ReportModule.useReports";
	public static final String PERMISSION_CREATE	= "ReportModule.createReports";
	
	
	
	/* ======================================== */
	// 		MEMBERS
	/* ======================================== */
	
//	/**
//	 * static logger for this class
//	 */
//	private static Logger			logger				= Logger.getLogger(ReportModule.class.getName());
	
	private static ImageIcon		reportmodule		= new ImageIcon(
			ReportModule.class.getResource("resources/icons/reportmodule.png"));
	
	private static ReportModule instance;
	
	
	private GECAMedAction			reloadReportsAction;
	
	private GECAMedAction			createReportAction;
	
	private GECAMedAction			editReportAction;
	
	private GECAMedAction			addReportAction;
	
	private GECAMedAction			removeReportAction;
	
//	private GECAMedAction			manageQueriesAction;
	
	private ReportList				reportList;
	
//	private ParameterQueryManagerDialog queryManagerDialog;
	
	private JMenu					reportMenu;
	
//	protected byte[]				reportBytes;
	
	
	
	/* ======================================== */
	// 		CONSTRUCTORS
	/* ======================================== */

	static
	{
		Translatrix.addBundle("lu.tudor.santec.gecamed.reporting.gui.resources.WidgetResources");
	}
	
	
	public ReportModule ()
	{
		super(MODULE_NAME, reportmodule, new Color(128,96,0,100));
		
		instance	= this;
		
		initComponents();
	}
	
	
	private void initComponents()
	{
		this.reportList	= new ReportList();
		this.setContentPanel(this.reportList);
		
		// add the menu
		this.reportMenu	= new JMenu(Translatrix.getTranslationString("ReportModule.report"));
		this.setModuleMenu(reportMenu);
		
		
		// RELOAD list
		this.reloadReportsAction = new GECAMedAction(this, "ReportModule.reloadReports", 
				IconFetcher.getIcon(GECAMedModule.class, GECAMedIconNames.RELOAD), KeyEvent.VK_R, true, true, false)
		{
			private static final long	serialVersionUID	= 1L;
			
			public void actionPerformed(ActionEvent p_Event)
			{
				reportList.reload();
			}
		};
		
		// CREATE report
		this.createReportAction	= new GECAMedAction(this, "ReportModule.createReport", 
				getButtonIcon("reportmodule.png"), KeyEvent.VK_N, true, true, false)
		{
			private static final long	serialVersionUID	= 1L;
			
			public void actionPerformed(ActionEvent p_Event)
			{
				if (reportList.isReportSelected())
					reportList.createReportFromSelectedTemplate();
			}
		};
		
		// EDIT report template
		this.editReportAction	= new GECAMedAction(this, "ReportModule.editReport", 
				getButtonIcon("edit.png"), KeyEvent.VK_E, true, true, false)
		{
			private static final long	serialVersionUID	= 1L;
			
			@Override
			public void actionPerformed(ActionEvent p_Event)
			{
				if (reportList.isReportSelected())
					reportList.editSelectedReportTemplate();
			}
		};
		
		// ADD report template
		this.addReportAction	= new GECAMedAction(this, "ReportModule.addReport", 
				getButtonIcon("add.png"), KeyEvent.VK_A, true, true, false)
		{
			private static final long	serialVersionUID	= 1L;
			
			public void actionPerformed(ActionEvent p_Event)
			{
				reportList.addReportTemplate();
			}
		};
		
		// REMOVE report template
		this.removeReportAction	= new GECAMedAction(this, "ReportModule.removeReport", 
				getButtonIcon("remove.png"), KeyEvent.VK_R, true, true, false)
		{
			private static final long	serialVersionUID	= 1L;
			
			@Override
			public void actionPerformed(ActionEvent p_Event)
			{
				if (reportList.isReportSelected())
					reportList.removeSelectedReportTemplate();
			}
		};
		
		// MANAGE parameter queries
//		this.queryManagerDialog		= new ParameterQueryManagerDialog();
//		this.manageQueriesAction	= new GECAMedAction(this, "ReportModule.manageQueries", 
//				getButtonIcon("db_query.png"), KeyEvent.VK_Q, true, true, false)
//		{
//			private static final long	serialVersionUID	= 1L;
//			
//			public void actionPerformed(ActionEvent p_Event) 
//			{
//				queryManagerDialog.open();
//			}
//		};
		
		this.reportList.getList().addListSelectionListener(new ListSelectionListener()
		{
			public void valueChanged(ListSelectionEvent e)
			{
				boolean	selected	= reportList.isReportSelected();
				
				createReportAction.setEnabled(selected);
				editReportAction.setEnabled(selected);
				removeReportAction.setEnabled(selected);
			}
		});
		
		
		createReportAction.setEnabled(false);
		editReportAction.setEnabled(false);
		removeReportAction.setEnabled(false);
		
		// define the order of the top bar buttons
		this.createReportAction.add();
		if (userHasPermission(PERMISSION_CREATE))
		{
			this.editReportAction.add();
			this.addReportAction.add();
			this.removeReportAction.add();
		}
		super.addTopButtonSeparator();
		this.reloadReportsAction.add();
//		this.manageQueriesAction.add();
	}
	
	
	
	/* ======================================== */
	// 		GETTER & SETTER
	/* ======================================== */
	
	public static ReportModule getInstance()
	{
		return instance;
	}
	
	
	public ReportList getReportList ()
	{
		return this.reportList;
	}
	
	
	@Override
	public boolean isShown()
	{
		return userHasPermission(PERMISSION_USE)
				|| userHasPermission(PERMISSION_CREATE);
	}
	
	
	
	/* ======================================== */
	// 		CLASS BODY
	/* ======================================== */
	
	public static ImageIcon getButtonIcon (String iconName)
	{
		return IconFetcher.getScaledIcon(ReportModule.class, iconName, 32);
	}
}
