package lu.tudor.santec.gecamed.reporting.gui.designer;

import java.awt.BorderLayout;

import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

import lu.tudor.santec.i18n.Translatrix;

import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.SyntaxConstants;

public class QueryBuilder extends JPanel
{
	/* ======================================== */
	// 		CONSTANTS
	/* ======================================== */
	
	private static final long	serialVersionUID	= 1L;
	
	
	
	/* ======================================== */
	// 		MEMBERS
	/* ======================================== */
	
	private RSyntaxTextArea	queryField;
	
	
	
	/* ======================================== */
	// 		CONSTRUCTORS
	/* ======================================== */
	
	public QueryBuilder()
	{
		this.setLayout(new BorderLayout());
		this.setBorder(new TitledBorder(Translatrix.getTranslationString("ReportModule.DesignerDialog.queryBuilder") + ":"));
		this.queryField	= new RSyntaxTextArea();
		this.queryField.setSyntaxEditingStyle(SyntaxConstants.SYNTAX_STYLE_SQL);
		this.add(queryField, BorderLayout.CENTER);
	}
	
	
	
	/* ======================================== */
	// 		CLASS BODY
	/* ======================================== */
	
	public void setQueryString (String query)
	{
		this.queryField.setText(query);
	}
	
	
	public String getQueryString ()
	{
		return this.queryField.getText();
	}
}
