package lu.tudor.santec.gecamed.reporting.gui.designer;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class VariableNameDocument extends PlainDocument
{
	/* ======================================== */
	// 		CONSTANTS
	/* ======================================== */
	
	private static final long	serialVersionUID	= 1L;
	
	
	
	/* ======================================== */
	// 		CLASS BODY
	/* ======================================== */
	
	@Override
	public void remove(int offs, int len) throws BadLocationException
	{
		super.remove(offs, len);
		
		// first sign must not be a digit
		if (offs == 0)
			while (getText(0, 1).matches("^\\d"))
				super.remove(0, 1);
	}
	
	
	@Override
	public void insertString(int offs, String str, AttributeSet a) throws BadLocationException
	{
		// remove all characters that are not A-z, a-z, 0-9 or _
		str	= str.replaceAll("\\W", "");
		// first character must not be a digit
		if (offs == 0)
			while (str.matches("^\\d.*"))
				str	= str.substring(1);
		
		if (str.length() > 0)
			super.insertString(offs, str, a);
	}
}
