/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.usermanagement.ejb.entity.beans;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

//***************************************************************************
//* Class Definition and Members                                            	*
//*																		*
//* History 																*
//* Version    Date    Authors Modification								*
//*  1.0    --/--/--   jher    Initial Release								* 
//*  1.1    06/06/21   nmac    Replaced Right Bean by Permission Bean 		*
//*							 Renamed NamedQueries and added				*
//*							 getAllPermissionsByModule method				*
//***************************************************************************

/**
 * Entity Bean that maps the <b>usermanagement.permission</b> table
 * 
 * The Permission class, p.k.a Rights class, represents a specific permission
 * to do something. Permissions will normaly be 'bundled' via roles which in
 * turn will be assigned to specific users. For reasons of flexibility, 
 * permissions may also be explicitly assigned to single users.
 * 
 * @Version
 * <br>$Log$
 * <br>Revision 1.5  2008-10-07 09:32:59  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.4  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.3  2008-01-15 09:30:14  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 * <br>Revision 1.2  2008-01-08 09:08:13  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */
@NamedQueries
	({
    @NamedQuery(name="getAllPermissions", 		   query="SELECT OBJECT(o) FROM Permission o"),
    @NamedQuery(name="getPermissionByDescription", query="SELECT OBJECT(o) FROM Permission o WHERE o.description = :description"),
    @NamedQuery(name="getPermissionByName", 	   query="SELECT OBJECT(o) FROM Permission o WHERE o.name = :name"),
    @NamedQuery(name="getAllPermissionsByModule",  query="SELECT OBJECT(o) FROM Permission o WHERE o.name like :module")
	})

@Entity
@Table(name = "permission", schema = "usermanagement")

public class Permission extends GECAMedEntityBean implements Serializable 
	{
	private static final long serialVersionUID = 1L;
	
	private String 	m_Description;
	private String 	m_Name;
	
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************	
		
//***************************************************************************
//* Getter and Setter Methods	                                              *
//***************************************************************************	

//---------------------------------------------------------------------------
/**
 * Returns the description for this permission 
 * @return Description of permission
 */
//---------------------------------------------------------------------------

@Column(name = "description")

public String getDescription() 
	{
	return m_Description;
	}

//---------------------------------------------------------------------------
/**
 * Sets the description for this permission 
 * @param p_Description specifies the new description for this permission
 */
//---------------------------------------------------------------------------

public void setDescription (String p_Description) 
	{
	m_Description = p_Description;
	}

//---------------------------------------------------------------------------
/**
 * Returns the unique name for this permission 
 * @return Unique name of permission
 */
//---------------------------------------------------------------------------

@Column(name = "name")

public String getName() 
	{
	return m_Name;
	}

//---------------------------------------------------------------------------
/**
 * Sets the unique name for this permission 
 * @param p_Name specifies the new unique name for this permission
 */
//---------------------------------------------------------------------------

public void setName(String p_Name) 
	{
	m_Name = p_Name;
	}

//---------------------------------------------------------------------------
/**
 * Returns a string representation of this permission 
 * @return Simply returns the unique name of this permission
 */
//---------------------------------------------------------------------------

public String toString() 
	{
    return this.getName();
    }
    
//***************************************************************************
//* End of Class															*
//***************************************************************************
}
