/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.usermanagement.ejb.entity.beans;

import java.io.Serializable;
import java.util.Collection;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

//***************************************************************************
//* Class Definition and Members                                            	*
//*																		*
//* History 																*
//* Version    Date    Authors Modification								*
//*  1.0    --/--/--   jher    Initial Release								* 
//*  1.1    06/06/21   nmac    Replaced Right Bean by Permission Bean 		*
//*							 Renamed NamedQueries and added				*
//***************************************************************************

/**
 * Entity Bean that maps the <b>usermanagement.role</b> table
 * 
 * The Role class represents a given set of permissions
 * 
 * @Version
 * <br>$Log: Role.java,v $
 * <br>Revision 1.7  2008-10-07 09:32:59  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.6  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.5  2008-01-15 09:30:13  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 * <br>Revision 1.4  2008-01-08 09:08:12  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */


@NamedQueries
	({
    @NamedQuery(name="getAllRoles", 			query="SELECT OBJECT(o) FROM Role o"),
    @NamedQuery(name="getRoleByDescription", 	query="SELECT OBJECT(o) FROM Role o WHERE o.description = :description"),
    @NamedQuery(name="getRoleByName", 			query="SELECT OBJECT(o) FROM Role o WHERE o.name = :name")
	})

@Entity
@Table(name = "role", schema = "usermanagement")

public class Role extends GECAMedEntityBean implements Serializable 
	{

	private static final long serialVersionUID = 1L;
	
	public static final String ADMIN = "PatientModule.admin";
	

	private String 					m_Description;
	private String 					m_Name;
	private Collection<Permission> 	m_Permissions;
	
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************	
			
//***************************************************************************
//* Overrrides				                                              *
//***************************************************************************	

//---------------------------------------------------------------------------
/**
 * Returns a string representation of this role 
 * @return Simply returns the unique name of this role
 */
//---------------------------------------------------------------------------

public String toString() 
	{
	return this.getName();	
	}
	    
//---------------------------------------------------------------------------
		
@Override
public boolean equals (Object p_Object) 
	{
	try {
		return this.getName().equals(((Role)p_Object).getName());
		} 
	catch (Exception p_Exception) 
		{
		return false;
		}	
	}

//***************************************************************************
//* Getter and Setter Methods	                                              *
//***************************************************************************	

//---------------------------------------------------------------------------
/**
 * Returns the description for this role 
 * @return Description of role
 */
//---------------------------------------------------------------------------

@Column(name = "description")

public String getDescription() 
	{
	return m_Description;
	}

//---------------------------------------------------------------------------
/**
 * Sets the description for this role 
 * @param p_Description specifies the new description for this role
 */
//---------------------------------------------------------------------------
	
public void setDescription (String p_Description) 
	{
	m_Description = p_Description;
	}

//---------------------------------------------------------------------------
/**
 * Returns the unique name for this role 
 * @return Unique name of role
 */
//---------------------------------------------------------------------------

@Column(name = "name")

public java.lang.String getName() 
	{
	return m_Name;
	}

//---------------------------------------------------------------------------
/**
 * Sets the unique name for this permission 
 * @param p_Name specifies the new unique name for this permission
 */
//---------------------------------------------------------------------------

public void setName (String p_Name) 
	{
	m_Name = p_Name;
	}

//---------------------------------------------------------------------------
/**
 * Returns the permissions associated with this role 
 * @return Associated permission set
 */
//---------------------------------------------------------------------------

@ManyToMany(cascade = {CascadeType.PERSIST, CascadeType.MERGE}, fetch = FetchType.EAGER)
		   @JoinTable(name = "rel_role_permission", schema = "usermanagement",
				   	 joinColumns 		= {@JoinColumn(name = "role_id")},
				   	 inverseJoinColumns 	= {@JoinColumn(name = "permission_id")})

public Collection<Permission> getPermissions() 
	{
	return m_Permissions;
	}

//---------------------------------------------------------------------------
/**
 * Assigns the specified set of permissions to this role 
 * @param p_Permissions specifies the permission set to be associated with
 *        this role. 
 */
//---------------------------------------------------------------------------

public void setPermissions (Collection<Permission> p_Permissions) 
	{
	m_Permissions = p_Permissions;
	}
    
	
}
