/*****************************************************************************
 *                                                                           *
 *  Copyright (c) 2010 by SANTEC/TUDOR www.santec.tudor.lu                   *
 *                                                                           *
 *                                                                           *
 *  This library is free software; you can redistribute it and/or modify it  *
 *  under the terms of the GNU Lesser General Public License as published    *
 *  by the Free Software Foundation; either version 2 of the License, or     *
 *  (at your option) any later version.                                      *
 *                                                                           *
 *  This software is distributed in the hope that it will be useful, but     *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of               *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU        *
 *  Lesser General Public License for more details.                          *
 *                                                                           *
 *  You should have received a copy of the GNU Lesser General Public         *
 *  License along with this library; if not, write to the Free Software      *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA  *
 *                                                                           *
 *****************************************************************************/
package lu.tudor.santec.gecamed.usermanagement.ejb.session.beans;

import java.util.Collection;

import javax.annotation.security.RolesAllowed;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

import lu.tudor.santec.gecamed.usermanagement.ejb.entity.beans.UserMessage;
import lu.tudor.santec.gecamed.usermanagement.ejb.session.interfaces.UserMessageInterface;

/**
 * Session bean interface that manages the access to all usermessages beans/tables in the data base usermanagement.message
 * 
 * @author Thorsten Roth thorsten.roth(at)tudor.lu
 *
 * @version
 * <br>$Log: UserMessageManager.java,v $
 * <br>Revision 1.3  2012-03-20 14:34:16  ferring
 * <br>Method markRead removed, because it was empty and unused
 * <br>
 * <br>Revision 1.2  2011-11-15 08:59:17  ferring
 * <br>Exceptions prevented
 * <br>
 * <br>Revision 1.1  2010-02-09 13:37:40  troth
 * <br>Create Session bean interface that manages the access to all usermessages beans/tables in the data base usermanagement.message
 * <br>
 */

@Remote ({UserMessageInterface.class})
@Stateless
public class UserMessageManager implements UserMessageInterface {

	@PersistenceContext(unitName = "gecam")
	protected EntityManager em;
	
	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.usermanagement.ejb.session.interfaces.UserMessageInterface#deleteUserMessage(lu.tudor.santec.gecamed.usermanagement.ejb.entity.beans.UserMessage)
	 */
	public void deleteUserMessage(UserMessage userMessage) {
		if (userMessage != null)
		{
			UserMessage c = em.find(UserMessage.class, userMessage.getId());
		    em.remove(c);
		}
	}

	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.usermanagement.ejb.session.interfaces.UserMessageInterface#markRead(lu.tudor.santec.gecamed.usermanagement.ejb.entity.beans.UserMessage)
	 */
//	public void markRead(UserMessage userMessage) {
//		
//	}

	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.usermanagement.ejb.session.interfaces.UserMessageInterface#saveUserMessage(lu.tudor.santec.gecamed.usermanagement.ejb.entity.beans.UserMessage)
	 */
	public void saveUserMessage(UserMessage userMessage) {
		em.merge(userMessage);
	}

	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.usermanagement.ejb.session.interfaces.UserMessageInterface#getUserMessage(java.lang.Integer)
	 */
	@SuppressWarnings("unchecked")
	@RolesAllowed("gecam")
	public Collection<UserMessage> getUserMessage(Integer receiverId) {
		
		Query q = em.createNamedQuery(UserMessage.QUERY_FIND_ALL_USERMESSAGE);
		q.setParameter(UserMessage.PARA_RECEIVER_ID, receiverId);
		Collection<UserMessage> l = q.getResultList();
		return l;
	}

}
