/*****************************************************************************
 *                                                                           *
 *  Copyright (c) 2010 by SANTEC/TUDOR www.santec.tudor.lu                   *
 *                                                                           *
 *                                                                           *
 *  This library is free software; you can redistribute it and/or modify it  *
 *  under the terms of the GNU Lesser General Public License as published    *
 *  by the Free Software Foundation; either version 2 of the License, or     *
 *  (at your option) any later version.                                      *
 *                                                                           *
 *  This software is distributed in the hope that it will be useful, but     *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of               *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU        *
 *  Lesser General Public License for more details.                          *
 *                                                                           *
 *  You should have received a copy of the GNU Lesser General Public         *
 *  License along with this library; if not, write to the Free Software      *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA  *
 *                                                                           *
 *****************************************************************************/
package lu.tudor.santec.gecamed.usermanagement.ejb.session.interfaces;

import java.util.Collection;

import lu.tudor.santec.gecamed.usermanagement.ejb.entity.beans.UserMessage;

/**
 * Session bean interface that manages the access to all usermessages beans/tables in the data base usermanagement.message
 * 
 * @author Thorsten Roth thorsten.roth(at)tudor.lu
 *
 * @version
 * <br>$Log: UserMessageInterface.java,v $
 * <br>Revision 1.2  2012-03-20 14:34:16  ferring
 * <br>Method markRead removed, because it was empty and unused
 * <br>
 * <br>Revision 1.1  2010-02-09 13:37:40  troth
 * <br>Create Session bean interface that manages the access to all usermessages beans/tables in the data base usermanagement.message
 * <br>
 */
public interface UserMessageInterface {

	/**
	 * returns a collection of all available messages of one specified User
	 * 
	 * @param userId the id of specified the user
	 * @return a collection of all available messages of one specified User
	 */
	public abstract Collection<UserMessage> getUserMessage(Integer userId);
	
	/**
	 * saves a message
	 * 
	 * @param userMessage the message to be saved
	 */
	public abstract void saveUserMessage(UserMessage userMessage);

	/**
	 * deletes a message
	 * 
	 * @param userMessage the message to be deleted
	 */
	public abstract void deleteUserMessage(UserMessage userMessage);

	/**
	 * marks a message if it is read or not read
	 * 
	 * @param userMessage the message to be marked
	 */
//	public abstract void markRead(UserMessage userMessage);

}