/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.usermanagement.gui.settings;

import java.awt.GridLayout;

import javax.swing.JComboBox;
import javax.swing.JPanel;

import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.i18n.Translatrix;
import lu.tudor.santec.settings.SettingsPlugin;

/**
 * Settings plugin to show/edit some general per-user settings in GECAMed
 * 
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @Version
 * <br>$Log: GeneralSettingsPlugin.java,v $
 * <br>Revision 1.28  2013-12-27 18:09:26  donak
 * <br>Cleanup of imports
 * <br>
 * <br>Revision 1.27  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.26  2008-08-04 10:06:13  hermen
 * <br>moved toolbarsize setting to usersettings
 * <br>
 * <br>Revision 1.25  2008-06-12 09:59:30  hermen
 * <br>changed some setting defaults
 * <br>
 * <br>Revision 1.24  2008-04-14 08:11:58  hermen
 * <br>added option to use big fonts for patient seatrch and reorganized search settings
 * <br>
 * <br>Revision 1.23  2008-03-13 10:11:46  hermen
 * <br>fixed translations
 * <br>
 * <br>Revision 1.22  2008-01-15 10:18:39  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */
public class GeneralSettingsPlugin extends SettingsPlugin {
	private static final long serialVersionUID = 1L;
	
//	/**
//	 * set the iconsize of the toolbar
//	 */
//	public static final String TOOLBAR_SIZE = "toolbarsize";

	
	public static final String NAME = "general";
	private JPanel wrPanel;

	
	private JComboBox toolbarSize;


	/**
	 * create a new settings plugin
	 * @param p_Name
	 */
	public GeneralSettingsPlugin(String p_Name) {
		super(p_Name);
		this.setStationaryValues();
		buildPanel();
	}
	
	/**
	 * create a new settings plugin
	 */
	public GeneralSettingsPlugin() {
		super(NAME);
		this.setStationaryValues();
		buildPanel();
	}

	/**
	 * creates the GUI panel
	 */
	private void buildPanel() {
		
		Translatrix.addBundle("lu.tudor.santec.gecamed.usermanagement.gui.resources.WidgetResources");
		
		setLabel(Translatrix.getTranslationString("GeneralSettings.Name"));
		
		this.wrPanel = createSubPanel(Translatrix
				.getTranslationString("GeneralSettings.Name"));
		this.wrPanel.setLayout(new GridLayout(0,1));
			
//		Integer[] sizes = {
//				Integer.valueOf(16),
//				Integer.valueOf(24),
//				Integer.valueOf(32),
//				Integer.valueOf(48)
//		};
//		this.toolbarSize = new JComboBox(sizes);
//		this.wrPanel.add(new NamedComponent(Translatrix.getTranslationString("GeneralSettings.ToolbarIconSize"), toolbarSize));

		
		addSubPanel(wrPanel);

		setIcon(GECAMedModule.getIcon(GECAMedIconNames.SETTINGS));
	}

	/* (non-Javadoc)
	 * @see lu.tudor.santec.settings.SettingsPlugin#revertToDefaults()
	 */
	public void revertToDefaults() {
//		this.toolbarSize.setSelectedItem((Integer) getDefault(TOOLBAR_SIZE));
		reflectSettings();
		super.revertToDefaults();
	}

	/* (non-Javadoc)
	 * @see lu.tudor.santec.settings.SettingsPlugin#updateSettings()
	 */
	public void updateSettings() {
//		setValue(TOOLBAR_SIZE, (Integer) this.toolbarSize.getSelectedItem());
		super.updateSettings();
	}

	/* (non-Javadoc)
	 * @see lu.tudor.santec.settings.SettingsPlugin#reflectSettings()
	 */
	public void reflectSettings() {
		super.reflectSettings();
//		this.toolbarSize.setSelectedItem((Integer) getValue(TOOLBAR_SIZE));
	}

	/* (non-Javadoc)
	 * @see lu.tudor.santec.settings.SettingsPlugin#relocalize()
	 */
	public void relocalize() {
		super.relocalize();
		
		setLabel(Translatrix.getTranslationString("GeneralSettings.Name"));
		setSubPanelTitle(wrPanel, Translatrix
				.getTranslationString("GeneralSettings.Name"));
	}
	
	/**
	 * set some static defaults
	 */
	public void setStationaryValues() {
//		setStationary(TOOLBAR_SIZE, 32);
	}
	
	
}
