/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/**
 * @author Martin Heinemann martin.heinemann@tudor.lu
 *
 *
 *
 * @version
 * <br>$Log: Room.java,v $
 * <br>Revision 1.7  2010-04-30 13:08:42  hermen
 * <br>added site to waitingroom
 * <br>
 * <br>Revision 1.6  2009-10-13 09:11:02  hermen
 * <br>Add/Delete/Edit Waitingroom are now in the admin-settings.
 * <br>Description of Waitingroom can be changed by user
 * <br>
 * <br>Revision 1.5  2009-10-06 14:16:13  hermen
 * <br>added isVisit to waitingroom entry
 * <br>
 * <br>Revision 1.4  2008-09-25 09:43:10  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.3  2008-05-07 14:39:53  heinemann
 * <br>new waitingroom
 * <br>
 * <br>Revision 1.2  2008-04-29 14:17:38  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.1  2008-02-11 16:47:53  heinemann
 * <br>Initial checkin
 * <br>
 *   
 */
package lu.tudor.santec.gecamed.waitingroom.ejb.entity.beans;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;


@Entity
@Table(schema="waitingroom", name="reasons")
public class Reason extends GECAMedEntityBean {

	private static final long serialVersionUID = 1L;
	
	private String label;

	public Reason() {
		
	}
	
	public Reason(String label) {
		this.label = label;
	}

	@Column(name="label")
	public String getLabel() {
		return label;
	}

	public void setLabel(String label) {
		this.label = label;
	}

	public String toString() {
	    return (this.getId() != null ?this.getId() + " - ":"") + this.getLabel();
	}

}
