/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/**
 * @author Martin Heinemann martin.heinemann@tudor.lu
 *
 *
 *
 * @version
 * <br>$Log: Room.java,v $
 * <br>Revision 1.7  2010-04-30 13:08:42  hermen
 * <br>added site to waitingroom
 * <br>
 * <br>Revision 1.6  2009-10-13 09:11:02  hermen
 * <br>Add/Delete/Edit Waitingroom are now in the admin-settings.
 * <br>Description of Waitingroom can be changed by user
 * <br>
 * <br>Revision 1.5  2009-10-06 14:16:13  hermen
 * <br>added isVisit to waitingroom entry
 * <br>
 * <br>Revision 1.4  2008-09-25 09:43:10  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.3  2008-05-07 14:39:53  heinemann
 * <br>new waitingroom
 * <br>
 * <br>Revision 1.2  2008-04-29 14:17:38  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.1  2008-02-11 16:47:53  heinemann
 * <br>Initial checkin
 * <br>
 *   
 */
package lu.tudor.santec.gecamed.waitingroom.ejb.entity.beans;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

/**
 * This bean represents a room in a medical office. It can be either a waitingroom
 * or a consultation room.
 * 
 * 
 * @author martin.heinemann@tudor.lu
 * 23.01.2008
 * 15:33:29
 *
 *
 * @version
 * <br>$Log: Room.java,v $
 * <br>Revision 1.7  2010-04-30 13:08:42  hermen
 * <br>added site to waitingroom
 * <br>
 * <br>Revision 1.6  2009-10-13 09:11:02  hermen
 * <br>Add/Delete/Edit Waitingroom are now in the admin-settings.
 * <br>Description of Waitingroom can be changed by user
 * <br>
 * <br>Revision 1.5  2009-10-06 14:16:13  hermen
 * <br>added isVisit to waitingroom entry
 * <br>
 * <br>Revision 1.4  2008-09-25 09:43:10  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.3  2008-05-07 14:39:53  heinemann
 * <br>new waitingroom
 * <br>
 * <br>Revision 1.2  2008-04-29 14:17:38  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.1  2008-02-11 16:47:53  heinemann
 * <br>Initial checkin
 * <br>
 *   
 */


@Entity
@Table(schema="waitingroom", name="room")
public class Room extends GECAMedEntityBean {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	
	private String name;
	
	private String description;
	
	private Boolean isWaitingroom;
	
	private Integer color;
	
	private Integer physicianId;
	
	private Integer orderId;
	
	private Integer calendarId;
	
	private Integer siteId;
	
	
	/**
	 * 
	 */
	public Room() {
		/* ================================================== */

		/* ================================================== */
	}

	/**
	 * @return the name
	 */
	@Column(name="name")
	public String getName() {
		return name;
	}

	/**
	 * @param name the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return the isWaitingroom
	 */
	@Column(name="is_waitingroom")
	public Boolean getIsWaitingroom() {
		return isWaitingroom;
	}

	/**
	 * @param isWaitingroom the isWaitingroom to set
	 */
	public void setIsWaitingroom(Boolean isWaitingroom) {
		this.isWaitingroom = isWaitingroom;
	}

	/**
	 * @return the color
	 */
	@Column(name="color")
	public Integer getColor() {
		return color;
	}

	/**
	 * @param color the color to set
	 */
	public void setColor(Integer color) {
		this.color = color;
	}

	/**
	 * @return the physicianId
	 */
	@Column(name="physician_id")
	public Integer getPhysicianId() {
		return physicianId;
	}

	/**
	 * @param physicianId the physicianId to set
	 */
	public void setPhysicianId(Integer physicianId) {
		this.physicianId = physicianId;
	}

	/**
	 * @return the order
	 */
	@Column(name="order_id")
	public Integer getOrderId() {
		return orderId;
	}

	/**
	 * @param order the order to set
	 */
	public void setOrderId(Integer order) {
		this.orderId = order;
	}

	/**
	 * @return the calendarId
	 */
	@Column(name="calendar_id")
	public Integer getCalendarId() {
		return calendarId;
	}

	/**
	 * @param calendarId the calendarId to set
	 */
	public void setCalendarId(Integer calendarId) {
		this.calendarId = calendarId;
	}

	@Column(name="description")
	public String getDescription() {
	    return description;
	}
	
	public void setDescription(String description) {
	    this.description = description;
	}

	@Column(name="site_id")
	public Integer getSiteId() {
	    return siteId;
	}
	
	public void setSiteId(Integer siteId) {
	    this.siteId = siteId;
	}

	
	
	public String toString() {
	    return this.getName() + ((getDescription()!=null&&getDescription().length()>0)?" [" + getDescription() + "]":"");
	}

	
	

}
