/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.waitingroom.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JTextField;

import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.widgets.GECAMedBaseDialog;
import lu.tudor.santec.gecamed.waitingroom.ejb.entity.beans.Room;
import lu.tudor.santec.i18n.Translatrix;
import lu.tudor.santec.widgets.gui.form.FormPanel;

/**
 *
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @version
 * <br>$Log: WaitingroomEditDescriptionDialog.java,v $
 * <br>Revision 1.1  2009-10-13 09:11:02  hermen
 * <br>Add/Delete/Edit Waitingroom are now in the admin-settings.
 * <br>Description of Waitingroom can be changed by user
 * <br>
 *
 */
public class WaitingroomEditDescriptionDialog extends GECAMedBaseDialog implements ActionListener {

	private static final long serialVersionUID = 1L;
	private FormPanel mainPanel;
	private JTextField descField;
	private Room room;

	/**
	 * @param title
	 * @param createButtons
	 */
	private WaitingroomEditDescriptionDialog(String title, boolean createButtons) {
		/* ================================================== */
		super(title, createButtons);
		/* ================================================== */
	}
	
	
	/**
	 * 
	 */
	public WaitingroomEditDescriptionDialog() {
		/* ================================================== */
		this(Translatrix.getTranslationString("waitingroom.edit"), true);
		/* ------------------------------------------------------- */
		this.enableOkKeyMapping(true);
		this.enableCancelKeyMapping(true);
		/* ------------------------------------------------------- */
		buildPanel();
		initListener();
		/* ================================================== */
	}
	
	
	public void showDialog(Room room) {
		/* ================================================== */
		this.room = room;
		/* ------------------------------------------------------- */
		// set the data
		/* ------------------------------------------------------- */
		this.descField.setText(this.room.getDescription());
		this.pack();
		MainFrame.showDialogCentered(this);
		/* ================================================== */
	}
	
	/**
	 * 
	 */
	private void initListener() {
		/* ================================================== */
		this.okButton.addActionListener(    this);
		this.cancelButton.addActionListener(this);
		/* ================================================== */
	}
		
	/**
	 * 
	 */
	private void buildPanel() {
		/* ====================================================== */
		this.mainPanel = new FormPanel();
		/* ------------------------------------------------------- */
		this.descField 		= new JTextField(25);
		/* ------------------------------------------------------- */
		mainPanel.addLine(Translatrix.getTranslationString("core.name"), descField);
		mainPanel.addGap();
		/* ------------------------------------------------------- */
		mainPanel.setOpaque(false);
		
		this.addMainPanel(mainPanel);
		/* ====================================================== */
	}


	public void actionPerformed(ActionEvent e) {
		/* ====================================================== */
		if (this.okButton.equals(e.getSource())) {
			/* ------------------------------------------------------- */
			// copy the data from the fields to the room object
			/* ------------------------------------------------------- */
			this.room.setDescription(this.descField.getText());
		}
		if (this.cancelButton.equals(e.getSource())) {
			/* ------------------------------------------------------- */
			this.room = null;
			/* ------------------------------------------------------- */
		}
		/* ====================================================== */
	}

	/**
	 * Retuns the modified Room object. Null if nothing changed or escape
	 * 
	 * @return
	 */
	public Room getRoom() {
		/* ================================================== */
		return this.room;
		/* ================================================== */
	}
		
}
