/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.waitingroom.gui.physicianagenda;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingConstants;

import lu.tudor.santec.gecamed.core.gui.GECAMedFonts;
import lu.tudor.santec.gecamed.core.gui.IconFetcher;
import lu.tudor.santec.gecamed.core.gui.utils.LineColorCellRenderer;
import lu.tudor.santec.gecamed.waitingroom.ejb.entity.beans.Queue;
import lu.tudor.santec.gecamed.waitingroom.gui.Waitingroom;
import lu.tudor.santec.gecamed.waitingroom.gui.WaitingroomModule;
import lu.tudor.santec.gecamed.waitingroom.gui.WaitingroomTableModel;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

/**
 * @author martin.heinemann@tudor.lu
 * 28.04.2008
 * 16:36:25
 *
 *
 * @version
 * <br>$Log: PhysicianAgendaTableRenderer.java,v $
 * <br>Revision 1.8  2009-10-12 09:02:15  hermen
 * <br>-fixed rendering issue with comments in waitingroom
 * <br>-made rooms a tick smaller to fir 1280px screens
 * <br>
 * <br>Revision 1.7  2009-10-07 13:07:18  hermen
 * <br>added isVisit to waitingroom entry
 * <br>
 * <br>Revision 1.6  2009-10-06 14:16:13  hermen
 * <br>added isVisit to waitingroom entry
 * <br>
 * <br>Revision 1.5  2008-12-04 13:48:04  heinemann
 * <br>fixed nullpointer in getTabelCellRenderer.
 * <br>Just a workaround. Causes of the problem might are some synchronising things.
 * <br>
 * <br>Revision 1.4  2008-10-09 12:39:49  heinemann
 * <br>fixed date formatting ot he waitingroom times
 * <br>
 * <br>Revision 1.3  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.2  2008-07-18 13:44:32  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.1  2008-07-04 13:02:04  heinemann
 * <br>complete - # 159: Add notes to entries of the waitingroom
 * <br>http://santec.tudor.lu/trac/gecamed/ticket/159
 * <br>
 * <br>Revision 1.2  2008-05-07 14:40:57  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.1  2008-04-29 14:17:38  heinemann
 * <br>*** empty log message ***
 * <br>
 *   
 */
public class PhysicianAgendaTableRenderer extends LineColorCellRenderer{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private static SimpleDateFormat format = new SimpleDateFormat("HH:mm", Translatrix.getLocale());
	
	private AgendaLabel renderLabel;
	
	private JCheckBox box = new JCheckBox();
	
	private JLabel iconLabel = new JLabel();
	
	private WaitingroomTableModel model;
	
	private int mode;
	
	private ImageIcon treatedTrue = IconFetcher.getSmallIcon(WaitingroomModule.class, WaitingroomModule.TREATED_TRUE);
	private ImageIcon treatedFalse = IconFetcher.getSmallIcon(WaitingroomModule.class, WaitingroomModule.TREATED_FALSE);
	private ImageIcon presentTrue = IconFetcher.getSmallIcon(WaitingroomModule.class, WaitingroomModule.PRESENT_TRUE);
	private ImageIcon presentFalse = IconFetcher.getSmallIcon(WaitingroomModule.class, WaitingroomModule.PRESENT_FALSE);
	private ImageIcon visitTrue = IconFetcher.getSmallIcon(WaitingroomModule.class, WaitingroomModule.VISIT_TRUE);
	private ImageIcon visitFalse = IconFetcher.getSmallIcon(WaitingroomModule.class, WaitingroomModule.VISIT_FALSE);

	private lu.tudor.santec.gecamed.core.gui.utils.TextWrappingCellRenderer textRenderer;

	private static Font zoomFont = new Font(GECAMedFonts.BOLD_LABEL_FONT.getName(), GECAMedFonts.BOLD_LABEL_FONT.getStyle(), 13);
	
	
	public PhysicianAgendaTableRenderer(int mode, WaitingroomTableModel model) {
		/* ================================================== */
		this.mode = mode;
		this.model = model;
		renderLabel = new AgendaLabel();
		this.textRenderer = new lu.tudor.santec.gecamed.core.gui.utils.TextWrappingCellRenderer();
		/* ================================================== */
	}


	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.core.gui.utils.LineColorCellRenderer#getTableCellRendererComponent(javax.swing.JTable, java.lang.Object, boolean, boolean, int, int)
	 */
	@Override
	public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
		/* ====================================================== */
		Component renderObject = null;
		
		if (column == 2 && value != null) {
			/* ------------------------------------------------------- */
			renderObject = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
			
			if (model.mode == Waitingroom.MODE_PHYSICIAN) {
				if ((Boolean) value) {
				    iconLabel.setIcon(treatedTrue);
				} else {
				    iconLabel.setIcon(treatedFalse);	    
				}
			} else {
				if ((Boolean) value) {
				    iconLabel.setIcon(presentTrue);
				} else {
				    iconLabel.setIcon(presentFalse);	    
				}
			}
			iconLabel.setOpaque(true);
			iconLabel.setBackground(renderObject.getBackground());
			iconLabel.setHorizontalAlignment(SwingConstants.CENTER);
//			iconLabel.setToolTipText(model.getToolTip(row, column));
			renderObject = iconLabel;
			/* ------------------------------------------------------- */
		} else if (column == 3 && value != null) {
			/* ------------------------------------------------------- */
			renderObject = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
			if ((Boolean) value) {
			    iconLabel.setIcon(visitTrue);
			} else {
			    iconLabel.setIcon(visitFalse);	    
			}
			iconLabel.setOpaque(true);
			iconLabel.setBackground(renderObject.getBackground());
			iconLabel.setHorizontalAlignment(SwingConstants.CENTER);
//			iconLabel.setToolTipText(model.getToolTip(row, column));
			renderObject = iconLabel;
			/* ------------------------------------------------------- */
		} else if (value instanceof Date) {
				renderObject = super.getTableCellRendererComponent(table, format.format(value), isSelected,	hasFocus, row, column);
//				renderObject.setFont(GECAMedFonts.BOLD_LABEL_FONT);
				renderObject.setFont(zoomFont);
		}
		else if (value instanceof Boolean) {
				/* ------------------------------------------------------- */
				renderObject = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
				box.setSelected((Boolean) value);
				box.setBackground(renderObject.getBackground());
				box.setHorizontalAlignment(SwingConstants.CENTER);
//				box.setToolTipText(model.getToolTip(row, column));
				renderObject = box;
				/* ------------------------------------------------------- */
			}
		else if (value instanceof Queue) {
				/* ------------------------------------------------------- */
				Queue q = (Queue) value;
				String text  = (String) q.getPatientName();
				
//				if (text == null || text.length() == 0) {
//					text  = (String) q.getProperty(Queue.PROPERTY_PATIENTNAME);					
//				}
				
				if (q.getKilometers() != null && q.getKilometers() > 0) {
					text += " [" + q.getKilometers() + "km]";
				}
				
				renderLabel.setText(text);
				/* ------------------------------------------------------- */
				Component tmp = textRenderer.getTableCellRendererComponent(table, renderObject, isSelected,
						hasFocus, row, column);
				renderLabel.setBackground(tmp.getBackground());
				renderObject = renderLabel;
				/* ------------------------------------------------------- */
				// the color check
				/* ------------------------------------------------------- */
				Color color = Color.YELLOW;
				if (q.getAppointmentId() != null)
					color = Color.GREEN;
				if (q.getEmergency() != null && q.getEmergency())
					color = Color.RED;
				renderLabel.setColor(color);
				/* ------------------------------------------------------- */
				//  
				//    grey if not present and untreated
				//    color if present and untreated
				//    strike if treated
				/* ------------------------------------------------------- */
				if (q.getIsPresent() == null || !q.getIsPresent()) {
					/* ------------------------------------------------------- */
					// grey, will be done later
					if (isSelected)
						renderLabel.setBackground(Color.getHSBColor(0.0F, 0.0F, 0.85F));
					else
						renderLabel.setBackground(Color.getHSBColor(0.0F, 0.0F, 0.9F));
					/* ------------------------------------------------------- */
				}
				if (q.getTreated() != null && q.getTreated())
					renderLabel.strike();
				/* ------------------------------------------------------- */
			} else 
				if (value instanceof String) {
					/* ------------------------------------------------------- */
					renderObject = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
					/* ------------------------------------------------------- */
				}
				else renderObject = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
			
		/* ------------------------------------------------------- */
		//  
		//    grey if not present and untreated
		//    color if present and untreated
		//    strike if treated
		/* ------------------------------------------------------- */
		/* ------------------------------------------------------- */
		// change background to grey if not present
		/* ------------------------------------------------------- */
		Queue q = ((WaitingroomTableModel)table.getModel()).getQueue(row);
		if (q != null) {
			/* ------------------------------------------------------- */
			if ((q.getIsPresent() == null || !q.getIsPresent()) && renderObject != null) {
				if (isSelected)
					renderObject.setBackground(Color.getHSBColor(0.0F, 0.0F, 0.85F));
				else
					renderObject.setBackground(Color.getHSBColor(0.0F, 0.0F, 0.9F));
			}
			/* ------------------------------------------------------- */
			// strike if treated
			/* ------------------------------------------------------- */
			if (q.getTreated() != null && q.getTreated() && renderObject != null) {
				if (renderObject instanceof JLabel) {
					JLabel l = (JLabel) renderObject;
					l.setText("<html><span style=\"text-decoration:line-through;\">"+l.getText());
				}
			}
			/* ------------------------------------------------------- */
		}
		/* ------------------------------------------------------- */
//		renderObject.setSize(table.getColumnModel().getColumn(column).getWidth(),
//				getPreferredSize().height);
//
//		if (table.getRowHeight(row) < getPreferredSize().height) {
//			table.setRowHeight(row, getPreferredSize().height);
//		}
		/* ------------------------------------------------------- */
		try {
			((JComponent)renderObject).setToolTipText(model.getToolTip(row, column));			
		} catch (Exception e) {}
		
		return renderObject;
		/* ====================================================== */
	}
	
	
	
	
	/**
	 * @author martin.heinemann@tudor.lu
	 * 28.04.2008
	 * 17:07:19
	 *
	 *
	 * @version
	 * <br>$Log: PhysicianAgendaTableRenderer.java,v $
	 * <br>Revision 1.8  2009-10-12 09:02:15  hermen
	 * <br>-fixed rendering issue with comments in waitingroom
	 * <br>-made rooms a tick smaller to fir 1280px screens
	 * <br>
	 * <br>Revision 1.7  2009-10-07 13:07:18  hermen
	 * <br>added isVisit to waitingroom entry
	 * <br>
	 * <br>Revision 1.6  2009-10-06 14:16:13  hermen
	 * <br>added isVisit to waitingroom entry
	 * <br>
	 * <br>Revision 1.5  2008-12-04 13:48:04  heinemann
	 * <br>fixed nullpointer in getTabelCellRenderer.
	 * <br>Just a workaround. Causes of the problem might are some synchronising things.
	 * <br>
	 * <br>Revision 1.4  2008-10-09 12:39:49  heinemann
	 * <br>fixed date formatting ot he waitingroom times
	 * <br>
	 * <br>Revision 1.3  2008-09-25 09:43:07  heinemann
	 * <br>fixed copyrights
	 * <br>
	 * <br>Revision 1.2  2008-07-18 13:44:32  heinemann
	 * <br>*** empty log message ***
	 * <br>
	 * <br>Revision 1.1  2008-07-04 13:02:04  heinemann
	 * <br>complete - # 159: Add notes to entries of the waitingroom
	 * <br>http://santec.tudor.lu/trac/gecamed/ticket/159
	 * <br>
	 * <br>Revision 1.2  2008-05-07 14:40:57  heinemann
	 * <br>*** empty log message ***
	 * <br>
	 * <br>Revision 1.1  2008-04-29 14:17:38  heinemann
	 * <br>*** empty log message ***
	 * <br>
	 *   
	 */
	class AgendaLabel extends JPanel {
		
		private static final long serialVersionUID = 1L;
		
		private JLabel label;
		private JPanel colorPanel;
		private JPanel internColorPanel;


		public AgendaLabel() {
			/* ================================================== */
			this.setLayout(new BorderLayout());
			this.setOpaque(true);
			/* ------------------------------------------------------- */
			this.label 	    = new JLabel();
			label.setFont(zoomFont);
			this.colorPanel = new JPanel();
			initColorPanel();
			
			this.add(colorPanel, BorderLayout.WEST);
			this.add(label, 	 BorderLayout.CENTER);
			/* ================================================== */
		}
		
		public void setText(String text) {
			/* ================================================== */
			this.label.setText(text);
			/* ================================================== */
		}
		
		public String getText() {
			/* ================================================== */
			return this.label.getText();
			/* ================================================== */
		}
		
		public void strike() {
			/* ================================================== */
			this.label.setText("<html><span style=\"text-decoration:line-through;\">"+label.getText());
			/* ================================================== */
		}
		
		public void setColor(Color color) {
			/* ================================================== */
			internColorPanel.setBackground(color);
			internColorPanel.updateUI();
			/* ================================================== */
		}
		
		private void initColorPanel() {
			/* ================================================== */
			this.colorPanel.setLayout(new FormLayout("2px,11px,2px", "2px,11px,2px"));
			this.internColorPanel = new JPanel();
			/* ------------------------------------------------------- */
			colorPanel.setOpaque(false);
			internColorPanel.setOpaque(true);
			internColorPanel.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY, 1));
			/* ------------------------------------------------------- */
			CellConstraints cc = new CellConstraints();
			
			this.colorPanel.add(internColorPanel, cc.xy(2, 2));
			/* ------------------------------------------------------- */
			/* ================================================== */
		}
		
		@Override
		public void setBackground(Color color) {
			/* ================================================== */
			super.setBackground(color);
			if (internColorPanel != null)
				this.internColorPanel.setBackground(color);
			/* ================================================== */
		}
		
		
	}
	

}

