/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.waitingroom.gui.widgets;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTable;

import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.widgets.IntegerField;
import lu.tudor.santec.gecamed.core.gui.widgets.NamedComponent;
import lu.tudor.santec.gecamed.waitingroom.ejb.entity.beans.Queue;
import lu.tudor.santec.gecamed.waitingroom.gui.WaitingroomModule;
import lu.tudor.santec.gecamed.waitingroom.gui.WaitingroomTableModel;
import lu.tudor.santec.i18n.Translatrix;

/**
 * Offers a popup for the management of the 
 * entries in the waitingroom lists for
 * secretary and physician view
 * 
 * 
 * @author martin.heinemann@tudor.lu
 * 04.07.2008
 * 10:48:50
 *
 *
 * @version
 * <br>$Log: WaitingroomTablePopup.java,v $
 * <br>Revision 1.2  2008-09-25 09:43:08  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.1  2008-07-04 13:38:29  heinemann
 * <br>complete - # 159: Add notes to entries of the waitingroom
 * <br>http://santec.tudor.lu/trac/gecamed/ticket/159
 * <br>
 *   
 */
public class WaitingroomTablePopup {
	
	
	private JTable table;
	private WaitingroomTableModel wModel;
	private JPopupMenu pop;
	private AbstractAction presentAction;
	private AbstractAction leaveAction;
	private AbstractAction deleteAction;
	private AbstractAction emergencyAction;
	private AbstractAction noEmergencyAction;
	private AbstractAction commentAction;
	private AbstractAction treatedAction;
	private AbstractAction untreatedAction;
	private AbstractAction editAction;
	private WaitingroomModule module;


	/**
	 * @param table must have a WaitingroomTableModel
	 */
	public WaitingroomTablePopup(JTable table, WaitingroomModule module) {
		/* ================================================== */
		this.table = table;
		this.module = module;
		this.wModel = (WaitingroomTableModel) table.getModel();
		this.wModel.setModule(module);
		
		initPopup();
		/* ================================================== */
	}
	
	
	
	
	
	
	/**
	 * Assembles the popup and set visible
	 */
	public void adjustPopup() {
		/* ================================================== */
		int row = table.getSelectedRow();
		Queue q = this.wModel.getQueue(row);
		/* ------------------------------------------------------- */
		this.pop.removeAll();
		/* ------------------------------------------------------- */
		pop.add(editAction);
		// add a note
		/* ------------------------------------------------------- */
		pop.add(commentAction);
		/* ------------------------------------------------------- */
		// set treated /untreated
		/* ------------------------------------------------------- */
		if(q.getTreated())
			pop.add(untreatedAction);
		else
			pop.add(treatedAction);
		/* ------------------------------------------------------- */
		pop.add(new JSeparator());
		/* ------------------------------------------------------- */
		// presence actions
		/* ------------------------------------------------------- */
		if (q.getIsPresent())
			pop.add(this.leaveAction);
		else
			pop.add(this.presentAction);
		/* ------------------------------------------------------- */
		// emergency actions
		/* ------------------------------------------------------- */
		if (q.getEmergency())
			pop.add(this.noEmergencyAction);
		else
			pop.add(this.emergencyAction);
		/* ------------------------------------------------------- */
		pop.add(new JSeparator());
		/* ------------------------------------------------------- */
		// remove
		/* ------------------------------------------------------- */
		pop.add(this.deleteAction);
		/* ------------------------------------------------------- */
		if (q.getIsVisit() != null && q.getIsVisit()) {
			final IntegerField kilometers = new IntegerField(4);
			Integer kilo = q.getKilometers();
			if (kilo == null) kilo = 0;
			kilometers.setValue(kilo);
			kilometers.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					Integer kilo = kilometers.getValueInteger();
					if (kilo != null && kilo < 1) kilo = null;
					wModel.setKilometers(table.getSelectedRow(), kilo);
					pop.setVisible(false);
				}
			});
			pop.add(new NamedComponent("km", kilometers, true, JLabel.HORIZONTAL));
		}
		/* ================================================== */
	}
	
	/**
	 * @return the pop
	 */
	public JPopupMenu getPop() {
		/* ================================================== */
		return pop;
		/* ================================================== */
	}


	/**
	 * 
	 */
	private void initPopup() {
		/* ================================================== */
		this.pop = new JPopupMenu();
		
		this.presentAction = new AbstractAction(
				Translatrix.getTranslationString("waitingroom.present"), 
				GECAMedModule.getMediumIcon(GECAMedIconNames.DO)) {

					private static final long serialVersionUID = 1L;

					public void actionPerformed(ActionEvent e) {
						/* ====================================================== */
						wModel.togglePresence(table.getSelectedRow());
						/* ====================================================== */
					}
		};
		
		this.leaveAction = new AbstractAction(
				Translatrix.getTranslationString("waitingroom.leave"), 
				GECAMedModule.getMediumIcon(GECAMedIconNames.UNDO)) {

					private static final long serialVersionUID = 1L;

					public void actionPerformed(ActionEvent e) {
						/* ====================================================== */
						wModel.togglePresence(table.getSelectedRow());
						/* ====================================================== */
					}
		};
		/* ------------------------------------------------------- */
		this.deleteAction = new AbstractAction(
				Translatrix.getTranslationString("waitingroom.remove.patient"), 
				GECAMedModule.getMediumIcon(GECAMedIconNames.REMOVE)) {

					private static final long serialVersionUID = 1L;

					public void actionPerformed(ActionEvent e) {
						/* ====================================================== */
						wModel.removeRow(table.getSelectedRow());
						/* ====================================================== */
					}
		};
		/* ------------------------------------------------------- */
		this.emergencyAction = new AbstractAction(
				Translatrix.getTranslationString("waitingroom.emergency"), 
				GECAMedModule.getMediumIcon(GECAMedIconNames.WARNING)) {

					private static final long serialVersionUID = 1L;

					public void actionPerformed(ActionEvent e) {
						/* ====================================================== */
						wModel.toggleEmergency(table.getSelectedRow());
						/* ====================================================== */
					}
		};
		this.noEmergencyAction = new AbstractAction(
				Translatrix.getTranslationString("waitingroom.noemergency"), 
				GECAMedModule.getMediumIcon(GECAMedIconNames.WARNING)) {

					private static final long serialVersionUID = 1L;

					public void actionPerformed(ActionEvent e) {
						/* ====================================================== */
						wModel.toggleEmergency(table.getSelectedRow());
						/* ====================================================== */
					}
			
		};
		
		this.commentAction = new AbstractAction(
				Translatrix.getTranslationString("waitingroom.comment"), 
				GECAMedModule.getMediumIcon(GECAMedIconNames.MEMO)) {

					private static final long serialVersionUID = 1L;

					public void actionPerformed(ActionEvent e) {
						/* ====================================================== */
						int row = table.getSelectedRow();
						Queue q = wModel.getQueue(row);
						if (q.getDescription() == null || "".equals(q.getDescription()))
							q.setDescription(" ");
						wModel.createCacheData();
						wModel.fireTableDataChanged();
						/* --------------------------------------------------- */
						// if we are in the patient name row, we must increase
						// the row number to work in the comment row
						/* ------------------------------------------------------- */
						Object obj = wModel.getValueAt(row, 1);
						if (obj instanceof Queue)
							row++;
						/* ------------------------------------------------------- */
						table.editCellAt(row, 1);
						table.getEditorComponent().requestFocusInWindow();
						/* ====================================================== */
					}
		};
		
		this.treatedAction = new AbstractAction(
				Translatrix.getTranslationString("waitingroom.treated"), 
				GECAMedModule.getMediumIcon(GECAMedIconNames.PHYSICIAN)) {

					private static final long serialVersionUID = 1L;

					public void actionPerformed(ActionEvent e) {
						/* ====================================================== */
						wModel.toggleTreated(table.getSelectedRow());
						/* ====================================================== */
					}
		};

		this.untreatedAction = new AbstractAction(
				Translatrix.getTranslationString("waitingroom.untreated"), 
				GECAMedModule.getMediumIcon(GECAMedIconNames.PHYSICIAN_NO)) {

					private static final long serialVersionUID = 1L;

					public void actionPerformed(ActionEvent e) {
						/* ====================================================== */
						wModel.toggleTreated(table.getSelectedRow());
						/* ====================================================== */
					}
		};
		
		this.editAction = new AbstractAction(
				Translatrix.getTranslationString("waitingwoom.queue.edit"), 
				GECAMedModule.getMediumIcon(GECAMedIconNames.EDIT)) {

					private static final long serialVersionUID = 1L;

					public void actionPerformed(ActionEvent e) {
						/* ====================================================== */
						int row = table.getSelectedRow();
						Queue q = wModel.getQueue(row);

						wModel.editQueue(q);
						
//						QueueEditDialog sd = new QueueEditDialog();	
//						q = sd.showDialog(q);
//						
//						wModel.setQueue(q);
//						
//						if (module != null) {
//							module.reload(false);							
//						}
						/* ====================================================== */
					}
		};
		/* ================================================== */
	}
	
	
	
}
