/* waiting room sql schema */


CREATE SCHEMA waitingroom;

CREATE TABLE waitingroom.room (
	id SERIAL PRIMARY KEY,
	name VARCHAR(200) NOT NULL,
	is_waitingroom BOOL NOT NULL DEFAULT 'false',
	color INTEGER NULL,
	physician_id INTEGER NULL,
	order_id INTEGER NULL,
	calendar_id INTEGER NULL,
	description TEXT,
	site_id INTEGER
);

CREATE TABLE waitingroom.queue (
	id SERIAL PRIMARY KEY,
	appointment_id INTEGER NULL,
	patient_id INTEGER NULL,
	description TEXT NULL,
	room_id INTEGER NOT NULL,
	start_date TIMESTAMP NOT NULL DEFAULT 'NOW',
	end_date TIMESTAMP NULL,
	created_by INTEGER NOT NULL,
	order_id INTEGER NULL,
	physician_id INTEGER NULL,
	treated BOOLEAN NULL,
	emergency BOOLEAN NULL,
	is_present BOOLEAN NULL,
	is_visit BOOLEAN NULL,
	patient_name VARCHAR(200),
	kilometers INTEGER,
	reason 	INTEGER
);

CREATE TABLE waitingroom.reasons (
	id SERIAL PRIMARY KEY,
	label TEXT NOT NULL
);

ALTER TABLE waitingroom.queue ADD CONSTRAINT fk_queue_patientid
	FOREIGN KEY (patient_id) REFERENCES patient.patient(id) ON DELETE CASCADE;

ALTER TABLE waitingroom.queue ADD CONSTRAINT fk_queue_room_id
	FOREIGN KEY (room_id) REFERENCES waitingroom.room(id) ON DELETE CASCADE;
	
ALTER TABLE waitingroom.queue ADD CONSTRAINT fk_queue_user_id
	FOREIGN KEY (created_by) REFERENCES usermanagement.gecamed_user(id) ON DELETE NO ACTION;

ALTER TABLE waitingroom.queue ADD CONSTRAINT fk_queue_physician_id
	FOREIGN KEY (physician_id) REFERENCES office.physician(id) ON DELETE NO ACTION;

ALTER TABLE waitingroom.room ADD CONSTRAINT fk_room_site_id
    FOREIGN KEY (site_id) REFERENCES office.site(id) ON DELETE SET NULL;
