#!/bin/bash


# ==================================================
# author: jens.ferring@tudor.lu
# 
# This script shall install Java 1.5 on MacOS X
# including the Unlimited Strength Jurisdiction
# Usage for MacOS X til version 10.8.*.
# ==================================================


# Check whether this is a Mac
OS=`uname`
if [[ ! ("$OS" == "Darwin") ]]
then
	# This is not a Mac. Therefor the script will not be executed.
	exit
fi



# ------------------------------
# DEFINE THE FUNCTIONS
# ------------------------------

install_java () {
	
	echo "Starting to install Java 1.5"
	
	if [ ! -d $SCRIPT_FOLDER/1.5.0 ]
	then
		if [ -f $SCRIPT_FOLDER/java_1.5.zip ]
		then
			#extract the java zip
			echo "Exctracting Java 1.5 folder"
			sudo unzip -o $SCRIPT_FOLDER/java_1.5.zip -d $SCRIPT_FOLDER
		else
			echo "The Java 1.5 folder ZIP should be located at $SCRIPT_FOLDER/java_1.5.zip but cannot be found!"
			echo "Cannot install Java 1.5!"
			return
		fi
	fi
	
	if [ -d $JAVA_VERSIONS_FOLDER/1.5.0_30 ]
	then
		echo "Removing the folder 1.5.0_30 from the Java versions folder"
		sudo rm -rf $JAVA_VERSIONS_FOLDER/1.5.0_30
	fi
	
	
	if [ $OS_LVL -eq 0 ]
	then
		echo "Moving the Java 1.5 folder into the Java versions folder"
		sudo mv $SCRIPT_FOLDER/1.5.0 $JAVA_VERSIONS_FOLDER/1.5.0_30
	elif [ $OS_LVL -eq 1 ] 
	then
		# copy the content of the Java folder into the folder 1.5.0_30
		#sudo cp -r -f $INSTALL_FOLDER/1.5.0_30 $JAVA_VERSIONS_FOLDER/
		# use the ditto command as the normal copy will cause errors (directory causes a cycle)
		echo "Copying Java 1.5 folder to $JAVA_VERSIONS_FOLDER/1.5.0_30"
		sudo ditto -v --arch x86_64 $SCRIPT_FOLDER/1.5.0 $JAVA_VERSIONS_FOLDER/1.5.0_30
	else
		echo "The OS level is undefined. Cannot proceed!"
		return
	fi
	
	# delete the old 1.5 Java links
	echo "Deleting old Java 1.5 links / folders"
	if [ -L $JAVA_VERSIONS_FOLDER/1.5 ]
	then
		sudo rm -f $JAVA_VERSIONS_FOLDER/1.5
	else
		sudo rm -fr $JAVA_VERSIONS_FOLDER/1.5
	fi
	
	if [ -L $JAVA_VERSIONS_FOLDER/1.5.0 ]
	then
		sudo rm -f $JAVA_VERSIONS_FOLDER/1.5.0
	else
		sudo rm -fr $JAVA_VERSIONS_FOLDER/1.5.0
	fi
	
	# create links to this folder
	echo "Creating new links for folders 1.5 and 1.5.0 to 1.5.0_30"
	sudo ln -sf $JAVA_VERSIONS_FOLDER/1.5.0_30 $JAVA_VERSIONS_FOLDER/1.5
	sudo ln -sf $JAVA_VERSIONS_FOLDER/1.5.0_30 $JAVA_VERSIONS_FOLDER/1.5.0
	
	
	# check the symlinks for their existence
	if [ ! -h $JAVA_VERSIONS_FOLDER/1.5.0_30/Info.plist ]
	then
		echo "Recreating symlink $JAVA_VERSIONS_FOLDER/1.5.0_30/Info.plist"
		sudo ln -sf $JAVA_VERSIONS_FOLDER/1.5.0_30/Resources/Info.plist $JAVA_VERSIONS_FOLDER/1.5.0_30/
	fi
	
	if [ ! -h $JAVA_VERSIONS_FOLDER/1.5.0_30/MacOS/libjava.jnilib ]
	then
		if [ ! -d $JAVA_VERSIONS_FOLDER/1.5.0_30/MacOS ]
		then
			echo "Creating the MacOS folder in 1.5.0_30"
			sudo mkdir -p $JAVA_VERSIONS_FOLDER/1.5.0_30/MacOS
		fi
		
		echo "Creating the libjava.jnilib symlink in the MacOS folder"
		sudo ln -sf $JAVA_VERSIONS_FOLDER/1.5.0_30/Libraries/libjava.jnilib
	fi
	
	# create the symlink in the JVM folder
	if [ ! -d $JVM_FOLDER/jdk1.5.0_30.jdk ]
	then
		sudo mkdir -p $JVM_FOLDER/jdk1.5.0_30.jdk
	fi
	
	sudo ln -sf $JAVA_VERSIONS_FOLDER/1.5.0_30 $JVM_FOLDER/jdk1.5.0_30.jdk/Contents
}



# ------------------------------
# DEFINE THE VARIABLES
# ------------------------------

# store the current working directory
CWD=`pwd`
# store the force (re-)install parameter
FORCE_INSTALL=$1
# set the basedir of this script file
SCRIPT_FOLDER=$(dirname $0)
cd $SCRIPT_FOLDER
SCRIPT_FOLDER=`pwd`
# store the OS version
OS_VERSION=$(sw_vers -productVersion)
# set the folder where all Java versions are located
JAVA_VERSIONS_FOLDER=/System/Library/Frameworks/JavaVM.framework/Versions
JVM_FOLDER=/Library/Java/JavaVirtualMachines

if [ ! -d $JVM_FOLDER ] 
then
	sudo mkdir -p $JVM_FOLDER
	sudo mkdir -p /System$JVM_FOLDER
	sudo ln -sf $JVM_FOLDER/jdk1.5.0_30.jdk /System$JVM_FOLDER/1.5.0
fi


if [[ "$FORCE_INSTALL" == "" ]]
then
	echo "The force (re-)install parameter is not set. It is therefor set to 1 (force (re-)install)."
	FORCE_INSTALL=1
fi

# define the OS version and its level
IFS='.' read -a OSV <<< "$OS_VERSION"
if [ ${OSV[0]} -gt 10 ]; then
	OS_LVL=1
elif [ ${OSV[0]} -eq 10 ]; then
	if [ ${OSV[1]} -ge 8 ]; then
		OS_LVL=1
	else
		OS_LVL=0
	fi
else
	OS_LVL=0
fi

# test whether Java 1.5 is installed and can be used
#$JAVA_VERSIONS_FOLDER/1.5.0/Home/bin/java -version -d64 2>&1 | grep -p "1.5"
$JAVA_VERSIONS_FOLDER/1.5.0/Home/bin/java -jar -d64 ./test.jar
ERROR=$?

if [[ $ERROR -eq 0 && $FORCE_INSTALL -ne 1 ]]
then
	echo "Java 1.5 can be used. No need to reinstall Java 1.5!"
else
	if [ $ERROR -ne 0 ]
	then
		echo "Cannot use Java 1.5. Trying to install Java 1.5 ..."
	else
		echo "Forcing reinstallation of Java 1.5"
	fi
	
	install_java
fi

# goto the directory that was pwd at start of this script
cd $CWD

