
SET search_path = address, pg_catalog;

--
-- TOC entry 3157 (class 2606 OID 16626)
-- Dependencies: 221 221
-- Name: address_pkey; Type: CONSTRAINT; Schema: address; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY address
    ADD CONSTRAINT address_pkey PRIMARY KEY (id);


--
-- TOC entry 3149 (class 2606 OID 16579)
-- Dependencies: 213 213
-- Name: canton_pkey; Type: CONSTRAINT; Schema: address; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY canton
    ADD CONSTRAINT canton_pkey PRIMARY KEY (id);


--
-- TOC entry 3147 (class 2606 OID 16571)
-- Dependencies: 211 211
-- Name: country_pkey; Type: CONSTRAINT; Schema: address; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY country
    ADD CONSTRAINT country_pkey PRIMARY KEY (id);


--
-- TOC entry 3153 (class 2606 OID 16600)
-- Dependencies: 217 217
-- Name: locality_pkey; Type: CONSTRAINT; Schema: address; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY locality
    ADD CONSTRAINT locality_pkey PRIMARY KEY (id);


--
-- TOC entry 3151 (class 2606 OID 16587)
-- Dependencies: 215 215
-- Name: municipality_pkey; Type: CONSTRAINT; Schema: address; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY municipality
    ADD CONSTRAINT municipality_pkey PRIMARY KEY (id);


--
-- TOC entry 3145 (class 2606 OID 16563)
-- Dependencies: 209 209
-- Name: type_pkey; Type: CONSTRAINT; Schema: address; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY type
    ADD CONSTRAINT type_pkey PRIMARY KEY (id);


--
-- TOC entry 3155 (class 2606 OID 16613)
-- Dependencies: 219 219
-- Name: zip_pkey; Type: CONSTRAINT; Schema: address; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY zip
    ADD CONSTRAINT zip_pkey PRIMARY KEY (id);


SET search_path = addressbook, pg_catalog;

--
-- TOC entry 3403 (class 2606 OID 18438)
-- Dependencies: 407 407
-- Name: contact_address_pkey; Type: CONSTRAINT; Schema: addressbook; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY contact_address
    ADD CONSTRAINT contact_address_pkey PRIMARY KEY (id);


--
-- TOC entry 3401 (class 2606 OID 18430)
-- Dependencies: 405 405
-- Name: contact_pkey; Type: CONSTRAINT; Schema: addressbook; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY contact
    ADD CONSTRAINT contact_pkey PRIMARY KEY (id);


SET search_path = agenda, pg_catalog;

--
-- TOC entry 3383 (class 2606 OID 18318)
-- Dependencies: 395 395
-- Name: appointment_pkey; Type: CONSTRAINT; Schema: agenda; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY appointment
    ADD CONSTRAINT appointment_pkey PRIMARY KEY (id);


--
-- TOC entry 3381 (class 2606 OID 18300)
-- Dependencies: 393 393
-- Name: appointment_type_pkey; Type: CONSTRAINT; Schema: agenda; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY appointment_type
    ADD CONSTRAINT appointment_type_pkey PRIMARY KEY (id);


--
-- TOC entry 3379 (class 2606 OID 18275)
-- Dependencies: 391 391
-- Name: calendar_pkey; Type: CONSTRAINT; Schema: agenda; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY calendar
    ADD CONSTRAINT calendar_pkey PRIMARY KEY (id);


--
-- TOC entry 3387 (class 2606 OID 18346)
-- Dependencies: 397 397
-- Name: rel_user_calendar_selection_pkey; Type: CONSTRAINT; Schema: agenda; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY rel_user_calendar_selection
    ADD CONSTRAINT rel_user_calendar_selection_pkey PRIMARY KEY (id);


SET search_path = billing, pg_catalog;

--
-- TOC entry 3331 (class 2606 OID 17774)
-- Dependencies: 348 348
-- Name: account_pkey; Type: CONSTRAINT; Schema: billing; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY account
    ADD CONSTRAINT account_pkey PRIMARY KEY (id);


--
-- TOC entry 3363 (class 2606 OID 18058)
-- Dependencies: 374 374
-- Name: act_pkey; Type: CONSTRAINT; Schema: billing; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY act
    ADD CONSTRAINT act_pkey PRIMARY KEY (id);


--
-- TOC entry 3325 (class 2606 OID 17727)
-- Dependencies: 342 342
-- Name: bailiff_address_pkey; Type: CONSTRAINT; Schema: billing; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY bailiff_address
    ADD CONSTRAINT bailiff_address_pkey PRIMARY KEY (id);


--
-- TOC entry 3323 (class 2606 OID 17719)
-- Dependencies: 340 340
-- Name: bailiff_pkey; Type: CONSTRAINT; Schema: billing; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY bailiff
    ADD CONSTRAINT bailiff_pkey PRIMARY KEY (id);


--
-- TOC entry 3329 (class 2606 OID 17761)
-- Dependencies: 346 346
-- Name: bailiff_rate_pkey; Type: CONSTRAINT; Schema: billing; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY bailiff_rate
    ADD CONSTRAINT bailiff_rate_pkey PRIMARY KEY (id);


--
-- TOC entry 3361 (class 2606 OID 17985)
-- Dependencies: 372 372
-- Name: invoice_pkey; Type: CONSTRAINT; Schema: billing; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY invoice
    ADD CONSTRAINT invoice_pkey PRIMARY KEY (id);


--
-- TOC entry 3337 (class 2606 OID 17818)
-- Dependencies: 354 354
-- Name: key_value_pkey; Type: CONSTRAINT; Schema: billing; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY key_value
    ADD CONSTRAINT key_value_pkey PRIMARY KEY (id);


--
-- TOC entry 3375 (class 2606 OID 18215)
-- Dependencies: 383 383
-- Name: ledger_pkey; Type: CONSTRAINT; Schema: billing; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY ledger
    ADD CONSTRAINT ledger_pkey PRIMARY KEY (id);


--
-- TOC entry 3367 (class 2606 OID 18080)
-- Dependencies: 376 376
-- Name: memo_pkey; Type: CONSTRAINT; Schema: billing; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY memo
    ADD CONSTRAINT memo_pkey PRIMARY KEY (id);


--
-- TOC entry 3333 (class 2606 OID 17787)
-- Dependencies: 350 350
-- Name: payment_pkey; Type: CONSTRAINT; Schema: billing; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY payment
    ADD CONSTRAINT payment_pkey PRIMARY KEY (id);


--
-- TOC entry 3341 (class 2606 OID 17842)
-- Dependencies: 358 358
-- Name: rate_index_pkey; Type: CONSTRAINT; Schema: billing; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY rate_index
    ADD CONSTRAINT rate_index_pkey PRIMARY KEY (id);


--
-- TOC entry 3346 (class 2606 OID 17864)
-- Dependencies: 360 360
-- Name: rate_pkey; Type: CONSTRAINT; Schema: billing; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY rate
    ADD CONSTRAINT rate_pkey PRIMARY KEY (id);


--
-- TOC entry 3327 (class 2606 OID 17740)
-- Dependencies: 344 344
-- Name: rel_municipality_bailiff_pkey; Type: CONSTRAINT; Schema: billing; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY rel_municipality_bailiff
    ADD CONSTRAINT rel_municipality_bailiff_pkey PRIMARY KEY (id);


--
-- TOC entry 3356 (class 2606 OID 17940)
-- Dependencies: 368 368
-- Name: rel_statement_insurance_pkey; Type: CONSTRAINT; Schema: billing; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY rel_statement_insurance
    ADD CONSTRAINT rel_statement_insurance_pkey PRIMARY KEY (id);


--
-- TOC entry 3358 (class 2606 OID 17958)
-- Dependencies: 370 370
-- Name: rel_statement_physician_pkey; Type: CONSTRAINT; Schema: billing; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY rel_statement_physician
    ADD CONSTRAINT rel_statement_physician_pkey PRIMARY KEY (id);


--
-- TOC entry 3352 (class 2606 OID 17902)
-- Dependencies: 364 364
-- Name: rel_template_rate_pkey; Type: CONSTRAINT; Schema: billing; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY rel_template_rate
    ADD CONSTRAINT rel_template_rate_pkey PRIMARY KEY (id);


--
-- TOC entry 3335 (class 2606 OID 17795)
-- Dependencies: 352 352
-- Name: settlement_pkey; Type: CONSTRAINT; Schema: billing; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY settlement
    ADD CONSTRAINT settlement_pkey PRIMARY KEY (id);


--
-- TOC entry 3354 (class 2606 OID 17922)
-- Dependencies: 366 366
-- Name: statement_pkey; Type: CONSTRAINT; Schema: billing; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY statement
    ADD CONSTRAINT statement_pkey PRIMARY KEY (id);


--
-- TOC entry 3339 (class 2606 OID 17831)
-- Dependencies: 356 356
-- Name: suffix_pkey; Type: CONSTRAINT; Schema: billing; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY suffix
    ADD CONSTRAINT suffix_pkey PRIMARY KEY (id);


--
-- TOC entry 3350 (class 2606 OID 17889)
-- Dependencies: 362 362
-- Name: template_pkey; Type: CONSTRAINT; Schema: billing; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY template
    ADD CONSTRAINT template_pkey PRIMARY KEY (id);


--
-- TOC entry 3371 (class 2606 OID 18175)
-- Dependencies: 379 379
-- Name: trashed_act_pkey; Type: CONSTRAINT; Schema: billing; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY trashed_act
    ADD CONSTRAINT trashed_act_pkey PRIMARY KEY (id);


--
-- TOC entry 3369 (class 2606 OID 18104)
-- Dependencies: 377 377
-- Name: trashed_invoice_pkey; Type: CONSTRAINT; Schema: billing; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY trashed_invoice
    ADD CONSTRAINT trashed_invoice_pkey PRIMARY KEY (id);


--
-- TOC entry 3373 (class 2606 OID 18196)
-- Dependencies: 381 381
-- Name: trashed_memo_pkey; Type: CONSTRAINT; Schema: billing; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY trashed_memo
    ADD CONSTRAINT trashed_memo_pkey PRIMARY KEY (id);


--
-- TOC entry 3348 (class 2606 OID 17876)
-- Dependencies: 360 360
-- Name: un_rate_code; Type: CONSTRAINT; Schema: billing; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY rate
    ADD CONSTRAINT un_rate_code UNIQUE (code);


SET search_path = core, pg_catalog;

--
-- TOC entry 3140 (class 2606 OID 16539)
-- Dependencies: 205 205
-- Name: autocompletion_pkey; Type: CONSTRAINT; Schema: core; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY autocompletion
    ADD CONSTRAINT autocompletion_pkey PRIMARY KEY (id);


--
-- TOC entry 3124 (class 2606 OID 16451)
-- Dependencies: 189 189
-- Name: dr_title_pkey; Type: CONSTRAINT; Schema: core; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY dr_title
    ADD CONSTRAINT dr_title_pkey PRIMARY KEY (id);


--
-- TOC entry 3112 (class 2606 OID 16403)
-- Dependencies: 177 177
-- Name: gender_pkey; Type: CONSTRAINT; Schema: core; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY gender
    ADD CONSTRAINT gender_pkey PRIMARY KEY (id);


--
-- TOC entry 3138 (class 2606 OID 16525)
-- Dependencies: 203 203
-- Name: info_pkey; Type: CONSTRAINT; Schema: core; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY info
    ADD CONSTRAINT info_pkey PRIMARY KEY (id);


--
-- TOC entry 3114 (class 2606 OID 16411)
-- Dependencies: 179 179
-- Name: language_pkey; Type: CONSTRAINT; Schema: core; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY language
    ADD CONSTRAINT language_pkey PRIMARY KEY (id);


--
-- TOC entry 3120 (class 2606 OID 16435)
-- Dependencies: 185 185
-- Name: locale_pkey; Type: CONSTRAINT; Schema: core; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY locale
    ADD CONSTRAINT locale_pkey PRIMARY KEY (id);


--
-- TOC entry 3132 (class 2606 OID 16490)
-- Dependencies: 197 197
-- Name: log_pkey; Type: CONSTRAINT; Schema: core; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY log
    ADD CONSTRAINT log_pkey PRIMARY KEY (id);


--
-- TOC entry 3134 (class 2606 OID 16498)
-- Dependencies: 199 199
-- Name: log_types_pkey; Type: CONSTRAINT; Schema: core; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY log_types
    ADD CONSTRAINT log_types_pkey PRIMARY KEY (id);


--
-- TOC entry 3116 (class 2606 OID 16419)
-- Dependencies: 181 181
-- Name: marital_status_pkey; Type: CONSTRAINT; Schema: core; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY marital_status
    ADD CONSTRAINT marital_status_pkey PRIMARY KEY (id);


--
-- TOC entry 3130 (class 2606 OID 16479)
-- Dependencies: 195 195
-- Name: national_holiday_pkey; Type: CONSTRAINT; Schema: core; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY national_holiday
    ADD CONSTRAINT national_holiday_pkey PRIMARY KEY (id);


--
-- TOC entry 3118 (class 2606 OID 16427)
-- Dependencies: 183 183
-- Name: nationality_pkey; Type: CONSTRAINT; Schema: core; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY nationality
    ADD CONSTRAINT nationality_pkey PRIMARY KEY (id);


--
-- TOC entry 3126 (class 2606 OID 16459)
-- Dependencies: 191 191
-- Name: phone_type_pkey; Type: CONSTRAINT; Schema: core; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY phone_type
    ADD CONSTRAINT phone_type_pkey PRIMARY KEY (id);


--
-- TOC entry 3128 (class 2606 OID 16471)
-- Dependencies: 193 193
-- Name: template_type_pkey; Type: CONSTRAINT; Schema: core; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY template_type
    ADD CONSTRAINT template_type_pkey PRIMARY KEY (id);


--
-- TOC entry 3136 (class 2606 OID 16509)
-- Dependencies: 201 201
-- Name: templates_pkey; Type: CONSTRAINT; Schema: core; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY templates
    ADD CONSTRAINT templates_pkey PRIMARY KEY (id);


--
-- TOC entry 3122 (class 2606 OID 16443)
-- Dependencies: 187 187
-- Name: title_pkey; Type: CONSTRAINT; Schema: core; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY title
    ADD CONSTRAINT title_pkey PRIMARY KEY (id);


--
-- TOC entry 3143 (class 2606 OID 16553)
-- Dependencies: 207 207
-- Name: xsl_templates_pkey; Type: CONSTRAINT; Schema: core; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY xsl_templates
    ADD CONSTRAINT xsl_templates_pkey PRIMARY KEY (id);


SET search_path = dicom, pg_catalog;

--
-- TOC entry 3399 (class 2606 OID 18407)
-- Dependencies: 403 403
-- Name: image_pkey; Type: CONSTRAINT; Schema: dicom; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY image
    ADD CONSTRAINT image_pkey PRIMARY KEY (id);


--
-- TOC entry 3395 (class 2606 OID 18391)
-- Dependencies: 401 401
-- Name: series_pkey; Type: CONSTRAINT; Schema: dicom; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY series
    ADD CONSTRAINT series_pkey PRIMARY KEY (id);


--
-- TOC entry 3391 (class 2606 OID 18375)
-- Dependencies: 399 399
-- Name: study_pkey; Type: CONSTRAINT; Schema: dicom; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY study
    ADD CONSTRAINT study_pkey PRIMARY KEY (id);


SET search_path = formeditor, pg_catalog;

--
-- TOC entry 3456 (class 2606 OID 18807)
-- Dependencies: 448 448
-- Name: form_pkey; Type: CONSTRAINT; Schema: formeditor; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY form
    ADD CONSTRAINT form_pkey PRIMARY KEY (id);


--
-- TOC entry 3454 (class 2606 OID 18793)
-- Dependencies: 446 446
-- Name: form_template_pkey; Type: CONSTRAINT; Schema: formeditor; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY form_template
    ADD CONSTRAINT form_template_pkey PRIMARY KEY (id);


--
-- TOC entry 3461 (class 2606 OID 18838)
-- Dependencies: 450 450
-- Name: form_value_pkey; Type: CONSTRAINT; Schema: formeditor; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY form_value
    ADD CONSTRAINT form_value_pkey PRIMARY KEY (id);


SET search_path = labo, pg_catalog;

--
-- TOC entry 3431 (class 2606 OID 18625)
-- Dependencies: 427 427
-- Name: analysis_pkey; Type: CONSTRAINT; Schema: labo; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY analysis
    ADD CONSTRAINT analysis_pkey PRIMARY KEY (id);


--
-- TOC entry 3434 (class 2606 OID 18641)
-- Dependencies: 429 429
-- Name: antibiogram_pkey; Type: CONSTRAINT; Schema: labo; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY antibiogram
    ADD CONSTRAINT antibiogram_pkey PRIMARY KEY (id);


--
-- TOC entry 3437 (class 2606 OID 18654)
-- Dependencies: 431 431
-- Name: antibiotic_pkey; Type: CONSTRAINT; Schema: labo; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY antibiotic
    ADD CONSTRAINT antibiotic_pkey PRIMARY KEY (id);


--
-- TOC entry 3422 (class 2606 OID 18560)
-- Dependencies: 421 421
-- Name: connection_pkey; Type: CONSTRAINT; Schema: labo; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY connection
    ADD CONSTRAINT connection_pkey PRIMARY KEY (id);


--
-- TOC entry 3439 (class 2606 OID 18667)
-- Dependencies: 433 433
-- Name: culture_pkey; Type: CONSTRAINT; Schema: labo; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY culture
    ADD CONSTRAINT culture_pkey PRIMARY KEY (id);


--
-- TOC entry 3412 (class 2606 OID 18497)
-- Dependencies: 415 415
-- Name: labo_address_pkey; Type: CONSTRAINT; Schema: labo; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY labo_address
    ADD CONSTRAINT labo_address_pkey PRIMARY KEY (id);


--
-- TOC entry 3414 (class 2606 OID 18519)
-- Dependencies: 417 417
-- Name: labo_certificate_pkey; Type: CONSTRAINT; Schema: labo; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY labo_certificate
    ADD CONSTRAINT labo_certificate_pkey PRIMARY KEY (id);


--
-- TOC entry 3408 (class 2606 OID 18471)
-- Dependencies: 411 411
-- Name: laboratory_pkey; Type: CONSTRAINT; Schema: labo; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY laboratory
    ADD CONSTRAINT laboratory_pkey PRIMARY KEY (id);


--
-- TOC entry 3406 (class 2606 OID 18458)
-- Dependencies: 409 409
-- Name: masterpassword_pkey; Type: CONSTRAINT; Schema: labo; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY masterpassword
    ADD CONSTRAINT masterpassword_pkey PRIMARY KEY (id);


--
-- TOC entry 3418 (class 2606 OID 18537)
-- Dependencies: 419 419
-- Name: physician_key_pkey; Type: CONSTRAINT; Schema: labo; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY physician_key
    ADD CONSTRAINT physician_key_pkey PRIMARY KEY (id);


--
-- TOC entry 3442 (class 2606 OID 18680)
-- Dependencies: 435 435
-- Name: reaction_pkey; Type: CONSTRAINT; Schema: labo; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY reaction
    ADD CONSTRAINT reaction_pkey PRIMARY KEY (id);


--
-- TOC entry 3410 (class 2606 OID 18479)
-- Dependencies: 413 413
-- Name: rel_laboratory_contact_pkey; Type: CONSTRAINT; Schema: labo; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY rel_laboratory_contact
    ADD CONSTRAINT rel_laboratory_contact_pkey PRIMARY KEY (id);


--
-- TOC entry 3429 (class 2606 OID 18604)
-- Dependencies: 425 425
-- Name: rel_result_contact_pkey; Type: CONSTRAINT; Schema: labo; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY rel_result_contact
    ADD CONSTRAINT rel_result_contact_pkey PRIMARY KEY (id);


--
-- TOC entry 3426 (class 2606 OID 18581)
-- Dependencies: 423 423
-- Name: result_pkey; Type: CONSTRAINT; Schema: labo; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY result
    ADD CONSTRAINT result_pkey PRIMARY KEY (id);


--
-- TOC entry 3416 (class 2606 OID 18526)
-- Dependencies: 417 417
-- Name: un_labo_certificate_label; Type: CONSTRAINT; Schema: labo; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY labo_certificate
    ADD CONSTRAINT un_labo_certificate_label UNIQUE (label);


--
-- TOC entry 3420 (class 2606 OID 18549)
-- Dependencies: 419 419
-- Name: un_physician_key_label; Type: CONSTRAINT; Schema: labo; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY physician_key
    ADD CONSTRAINT un_physician_key_label UNIQUE (label);


SET search_path = letter, pg_catalog;

--
-- TOC entry 3452 (class 2606 OID 18772)
-- Dependencies: 444 444
-- Name: letters_pkey; Type: CONSTRAINT; Schema: letter; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY letters
    ADD CONSTRAINT letters_pkey PRIMARY KEY (id);


--
-- TOC entry 3448 (class 2606 OID 18764)
-- Dependencies: 442 442
-- Name: templates_pkey; Type: CONSTRAINT; Schema: letter; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY templates
    ADD CONSTRAINT templates_pkey PRIMARY KEY (id);


SET search_path = office, pg_catalog;

--
-- TOC entry 3186 (class 2606 OID 16796)
-- Dependencies: 243 243
-- Name: office_address_pkey; Type: CONSTRAINT; Schema: office; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY office_address
    ADD CONSTRAINT office_address_pkey PRIMARY KEY (id);


--
-- TOC entry 3184 (class 2606 OID 16783)
-- Dependencies: 241 241
-- Name: office_phone_pkey; Type: CONSTRAINT; Schema: office; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY office_phone
    ADD CONSTRAINT office_phone_pkey PRIMARY KEY (id);


--
-- TOC entry 3182 (class 2606 OID 16775)
-- Dependencies: 239 239
-- Name: office_pkey; Type: CONSTRAINT; Schema: office; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY office
    ADD CONSTRAINT office_pkey PRIMARY KEY (id);


--
-- TOC entry 3188 (class 2606 OID 16814)
-- Dependencies: 245 245
-- Name: physician_address_pkey; Type: CONSTRAINT; Schema: office; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY physician_address
    ADD CONSTRAINT physician_address_pkey PRIMARY KEY (id);


--
-- TOC entry 3190 (class 2606 OID 16830)
-- Dependencies: 247 247
-- Name: physician_pkey; Type: CONSTRAINT; Schema: office; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY physician
    ADD CONSTRAINT physician_pkey PRIMARY KEY (id);


--
-- TOC entry 3192 (class 2606 OID 16853)
-- Dependencies: 249 249
-- Name: site_address_pkey; Type: CONSTRAINT; Schema: office; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY site_address
    ADD CONSTRAINT site_address_pkey PRIMARY KEY (id);


--
-- TOC entry 3194 (class 2606 OID 16869)
-- Dependencies: 251 251
-- Name: site_pkey; Type: CONSTRAINT; Schema: office; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY site
    ADD CONSTRAINT site_pkey PRIMARY KEY (id);


SET search_path = patient, pg_catalog;

--
-- TOC entry 3289 (class 2606 OID 17413)
-- Dependencies: 309 309
-- Name: allergens_pkey; Type: CONSTRAINT; Schema: patient; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY allergens
    ADD CONSTRAINT allergens_pkey PRIMARY KEY (id);


--
-- TOC entry 3259 (class 2606 OID 17201)
-- Dependencies: 289 289
-- Name: allergies_pkey; Type: CONSTRAINT; Schema: patient; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY allergies
    ADD CONSTRAINT allergies_pkey PRIMARY KEY (id);


--
-- TOC entry 3263 (class 2606 OID 17213)
-- Dependencies: 291 291
-- Name: antecedents_pkey; Type: CONSTRAINT; Schema: patient; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY antecedents
    ADD CONSTRAINT antecedents_pkey PRIMARY KEY (id);


--
-- TOC entry 3267 (class 2606 OID 17230)
-- Dependencies: 293 293
-- Name: consultations_pkey; Type: CONSTRAINT; Schema: patient; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY consultations
    ADD CONSTRAINT consultations_pkey PRIMARY KEY (id);


--
-- TOC entry 3215 (class 2606 OID 16966)
-- Dependencies: 263 263
-- Name: hospital_department_pkey; Type: CONSTRAINT; Schema: patient; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY hospital_department
    ADD CONSTRAINT hospital_department_pkey PRIMARY KEY (id);


--
-- TOC entry 3234 (class 2606 OID 17052)
-- Dependencies: 275 275
-- Name: hospital_prescription_page_pkey; Type: CONSTRAINT; Schema: patient; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY hospital_prescription_page
    ADD CONSTRAINT hospital_prescription_page_pkey PRIMARY KEY (id);


--
-- TOC entry 3229 (class 2606 OID 17035)
-- Dependencies: 273 273
-- Name: hospital_prescription_pkey; Type: CONSTRAINT; Schema: patient; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY hospital_prescription
    ADD CONSTRAINT hospital_prescription_pkey PRIMARY KEY (id);


--
-- TOC entry 3238 (class 2606 OID 17069)
-- Dependencies: 277 277
-- Name: hospital_report_pkey; Type: CONSTRAINT; Schema: patient; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY hospital_report
    ADD CONSTRAINT hospital_report_pkey PRIMARY KEY (id);


--
-- TOC entry 3217 (class 2606 OID 16974)
-- Dependencies: 265 265
-- Name: hospitalisation_class_pkey; Type: CONSTRAINT; Schema: patient; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY hospitalisation_class
    ADD CONSTRAINT hospitalisation_class_pkey PRIMARY KEY (id);


--
-- TOC entry 3226 (class 2606 OID 17007)
-- Dependencies: 271 271
-- Name: hospitalisation_period_pkey; Type: CONSTRAINT; Schema: patient; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY hospitalisation_period
    ADD CONSTRAINT hospitalisation_period_pkey PRIMARY KEY (id);


--
-- TOC entry 3221 (class 2606 OID 16990)
-- Dependencies: 269 269
-- Name: hospitalisation_pkey; Type: CONSTRAINT; Schema: patient; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY hospitalisation
    ADD CONSTRAINT hospitalisation_pkey PRIMARY KEY (id);


--
-- TOC entry 3219 (class 2606 OID 16982)
-- Dependencies: 267 267
-- Name: hospitalisation_status_pkey; Type: CONSTRAINT; Schema: patient; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY hospitalisation_status
    ADD CONSTRAINT hospitalisation_status_pkey PRIMARY KEY (id);


--
-- TOC entry 3279 (class 2606 OID 17288)
-- Dependencies: 301 301
-- Name: incident_entry_pkey; Type: CONSTRAINT; Schema: patient; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY incident_entry
    ADD CONSTRAINT incident_entry_pkey PRIMARY KEY (id);


--
-- TOC entry 3276 (class 2606 OID 17277)
-- Dependencies: 299 299
-- Name: incident_entry_types_pkey; Type: CONSTRAINT; Schema: patient; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY incident_entry_types
    ADD CONSTRAINT incident_entry_types_pkey PRIMARY KEY (id);


--
-- TOC entry 3271 (class 2606 OID 17241)
-- Dependencies: 295 295
-- Name: incident_relations_pkey; Type: CONSTRAINT; Schema: patient; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY incident_relations
    ADD CONSTRAINT incident_relations_pkey PRIMARY KEY (id);


--
-- TOC entry 3274 (class 2606 OID 17251)
-- Dependencies: 297 297
-- Name: incidents_pkey; Type: CONSTRAINT; Schema: patient; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY incidents
    ADD CONSTRAINT incidents_pkey PRIMARY KEY (id);


--
-- TOC entry 3196 (class 2606 OID 16888)
-- Dependencies: 253 253
-- Name: insurance_pkey; Type: CONSTRAINT; Schema: patient; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY insurance
    ADD CONSTRAINT insurance_pkey PRIMARY KEY (id);


--
-- TOC entry 3198 (class 2606 OID 16896)
-- Dependencies: 255 255
-- Name: insurance_plan_pkey; Type: CONSTRAINT; Schema: patient; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY insurance_plan
    ADD CONSTRAINT insurance_plan_pkey PRIMARY KEY (id);


--
-- TOC entry 3281 (class 2606 OID 17318)
-- Dependencies: 303 303
-- Name: measurement_types_pkey; Type: CONSTRAINT; Schema: patient; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY measurement_types
    ADD CONSTRAINT measurement_types_pkey PRIMARY KEY (id);


--
-- TOC entry 3284 (class 2606 OID 17326)
-- Dependencies: 305 305
-- Name: measurement_values_pkey; Type: CONSTRAINT; Schema: patient; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY measurement_values
    ADD CONSTRAINT measurement_values_pkey PRIMARY KEY (id);


--
-- TOC entry 3243 (class 2606 OID 17087)
-- Dependencies: 279 279
-- Name: passage_pkey; Type: CONSTRAINT; Schema: patient; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY passage
    ADD CONSTRAINT passage_pkey PRIMARY KEY (id);


--
-- TOC entry 3246 (class 2606 OID 17121)
-- Dependencies: 281 281
-- Name: patient_address_pkey; Type: CONSTRAINT; Schema: patient; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY patient_address
    ADD CONSTRAINT patient_address_pkey PRIMARY KEY (id);


--
-- TOC entry 3249 (class 2606 OID 17139)
-- Dependencies: 283 283
-- Name: patient_contact_pkey; Type: CONSTRAINT; Schema: patient; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY patient_contact
    ADD CONSTRAINT patient_contact_pkey PRIMARY KEY (id);


--
-- TOC entry 3287 (class 2606 OID 17347)
-- Dependencies: 307 307
-- Name: patient_datas_pkey; Type: CONSTRAINT; Schema: patient; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY patient_datas
    ADD CONSTRAINT patient_datas_pkey PRIMARY KEY (id);


--
-- TOC entry 3210 (class 2606 OID 16940)
-- Dependencies: 259 259
-- Name: patient_foto_pkey; Type: CONSTRAINT; Schema: patient; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY patient_foto
    ADD CONSTRAINT patient_foto_pkey PRIMARY KEY (id);


--
-- TOC entry 3257 (class 2606 OID 17179)
-- Dependencies: 287 287
-- Name: patient_memo_pkey; Type: CONSTRAINT; Schema: patient; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY patient_memo
    ADD CONSTRAINT patient_memo_pkey PRIMARY KEY (id);


--
-- TOC entry 3213 (class 2606 OID 16953)
-- Dependencies: 261 261
-- Name: patient_phone_pkey; Type: CONSTRAINT; Schema: patient; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY patient_phone
    ADD CONSTRAINT patient_phone_pkey PRIMARY KEY (id);


--
-- TOC entry 3207 (class 2606 OID 16912)
-- Dependencies: 257 257
-- Name: patient_pkey; Type: CONSTRAINT; Schema: patient; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY patient
    ADD CONSTRAINT patient_pkey PRIMARY KEY (id);


--
-- TOC entry 3253 (class 2606 OID 17167)
-- Dependencies: 285 285 285 285
-- Name: pk_patient_relation; Type: CONSTRAINT; Schema: patient; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY patient_relation
    ADD CONSTRAINT pk_patient_relation PRIMARY KEY (parent_id, child_id, id);


SET search_path = prescription, pg_catalog;

--
-- TOC entry 3310 (class 2606 OID 17604)
-- Dependencies: 329 329
-- Name: cefip_atc_classes_pkey; Type: CONSTRAINT; Schema: prescription; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY cefip_atc_classes
    ADD CONSTRAINT cefip_atc_classes_pkey PRIMARY KEY (id);


--
-- TOC entry 3312 (class 2606 OID 17620)
-- Dependencies: 331 331
-- Name: cefip_drugs_pkey; Type: CONSTRAINT; Schema: prescription; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY cefip_drugs
    ADD CONSTRAINT cefip_drugs_pkey PRIMARY KEY (id);


--
-- TOC entry 3314 (class 2606 OID 17628)
-- Dependencies: 333 333
-- Name: cefip_manufacturer_pkey; Type: CONSTRAINT; Schema: prescription; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY cefip_manufacturer
    ADD CONSTRAINT cefip_manufacturer_pkey PRIMARY KEY (id);


--
-- TOC entry 3293 (class 2606 OID 17478)
-- Dependencies: 315 315
-- Name: drug_lists_pkey; Type: CONSTRAINT; Schema: prescription; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY drug_lists
    ADD CONSTRAINT drug_lists_pkey PRIMARY KEY (id);


--
-- TOC entry 3316 (class 2606 OID 17633)
-- Dependencies: 334 334 334
-- Name: pk_cefip_drug_atc; Type: CONSTRAINT; Schema: prescription; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY rel_cefip_drugs_atc_classes
    ADD CONSTRAINT pk_cefip_drug_atc PRIMARY KEY (atc_id, cefip_drug_id);


--
-- TOC entry 3291 (class 2606 OID 17467)
-- Dependencies: 313 313
-- Name: posologytemplates_pkey; Type: CONSTRAINT; Schema: prescription; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY posologytemplates
    ADD CONSTRAINT posologytemplates_pkey PRIMARY KEY (id);


--
-- TOC entry 3319 (class 2606 OID 17654)
-- Dependencies: 336 336
-- Name: prescription_drug_revisions_pkey; Type: CONSTRAINT; Schema: prescription; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY prescription_drug_revisions
    ADD CONSTRAINT prescription_drug_revisions_pkey PRIMARY KEY (id);


--
-- TOC entry 3296 (class 2606 OID 17489)
-- Dependencies: 317 317
-- Name: prescription_drugs_pkey; Type: CONSTRAINT; Schema: prescription; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY prescription_drugs
    ADD CONSTRAINT prescription_drugs_pkey PRIMARY KEY (id);


--
-- TOC entry 3321 (class 2606 OID 17666)
-- Dependencies: 338 338
-- Name: prescription_revisions_pkey; Type: CONSTRAINT; Schema: prescription; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY prescription_revisions
    ADD CONSTRAINT prescription_revisions_pkey PRIMARY KEY (id);


--
-- TOC entry 3298 (class 2606 OID 17497)
-- Dependencies: 319 319
-- Name: prescription_types_pkey; Type: CONSTRAINT; Schema: prescription; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY prescription_types
    ADD CONSTRAINT prescription_types_pkey PRIMARY KEY (id);


--
-- TOC entry 3301 (class 2606 OID 17509)
-- Dependencies: 321 321
-- Name: prescriptions_pkey; Type: CONSTRAINT; Schema: prescription; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY prescriptions
    ADD CONSTRAINT prescriptions_pkey PRIMARY KEY (id);


--
-- TOC entry 3308 (class 2606 OID 17546)
-- Dependencies: 327 327
-- Name: print_prescription_pkey; Type: CONSTRAINT; Schema: prescription; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY print_prescription
    ADD CONSTRAINT print_prescription_pkey PRIMARY KEY (id);


--
-- TOC entry 3303 (class 2606 OID 17525)
-- Dependencies: 323 323
-- Name: template_drugs_pkey; Type: CONSTRAINT; Schema: prescription; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY template_drugs
    ADD CONSTRAINT template_drugs_pkey PRIMARY KEY (id);


--
-- TOC entry 3305 (class 2606 OID 17537)
-- Dependencies: 325 325
-- Name: templates_pkey; Type: CONSTRAINT; Schema: prescription; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY templates
    ADD CONSTRAINT templates_pkey PRIMARY KEY (id);


SET search_path = reporting, pg_catalog;

--
-- TOC entry 3377 (class 2606 OID 18266)
-- Dependencies: 389 389
-- Name: report_pkey; Type: CONSTRAINT; Schema: reporting; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY report
    ADD CONSTRAINT report_pkey PRIMARY KEY (id);


SET search_path = usermanagement, pg_catalog;

--
-- TOC entry 3170 (class 2606 OID 16680)
-- Dependencies: 229 229
-- Name: gecamed_user_pkey; Type: CONSTRAINT; Schema: usermanagement; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY gecamed_user
    ADD CONSTRAINT gecamed_user_pkey PRIMARY KEY (id);


--
-- TOC entry 3180 (class 2606 OID 16753)
-- Dependencies: 237 237
-- Name: message_pkey; Type: CONSTRAINT; Schema: usermanagement; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY message
    ADD CONSTRAINT message_pkey PRIMARY KEY (id);


--
-- TOC entry 3159 (class 2606 OID 16638)
-- Dependencies: 223 223
-- Name: permission_pkey; Type: CONSTRAINT; Schema: usermanagement; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY permission
    ADD CONSTRAINT permission_pkey PRIMARY KEY (id);


--
-- TOC entry 3168 (class 2606 OID 16661)
-- Dependencies: 227 227
-- Name: rel_role_permission_pkey; Type: CONSTRAINT; Schema: usermanagement; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY rel_role_permission
    ADD CONSTRAINT rel_role_permission_pkey PRIMARY KEY (id);


--
-- TOC entry 3175 (class 2606 OID 16709)
-- Dependencies: 233 233
-- Name: rel_user_permission_pkey; Type: CONSTRAINT; Schema: usermanagement; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY rel_user_permission
    ADD CONSTRAINT rel_user_permission_pkey PRIMARY KEY (id);


--
-- TOC entry 3178 (class 2606 OID 16728)
-- Dependencies: 235 235
-- Name: rel_user_role_pkey; Type: CONSTRAINT; Schema: usermanagement; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY rel_user_role
    ADD CONSTRAINT rel_user_role_pkey PRIMARY KEY (id);


--
-- TOC entry 3163 (class 2606 OID 16651)
-- Dependencies: 225 225
-- Name: role_pkey; Type: CONSTRAINT; Schema: usermanagement; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY role
    ADD CONSTRAINT role_pkey PRIMARY KEY (id);


--
-- TOC entry 3172 (class 2606 OID 16701)
-- Dependencies: 231 231
-- Name: setting_pkey; Type: CONSTRAINT; Schema: usermanagement; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY setting
    ADD CONSTRAINT setting_pkey PRIMARY KEY (id);


--
-- TOC entry 3161 (class 2606 OID 16640)
-- Dependencies: 223 223
-- Name: unique_permission_name; Type: CONSTRAINT; Schema: usermanagement; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY permission
    ADD CONSTRAINT unique_permission_name UNIQUE (name);


--
-- TOC entry 3165 (class 2606 OID 16653)
-- Dependencies: 225 225
-- Name: unique_role_name; Type: CONSTRAINT; Schema: usermanagement; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY role
    ADD CONSTRAINT unique_role_name UNIQUE (name);


SET search_path = waitingroom, pg_catalog;

--
-- TOC entry 3446 (class 2606 OID 18721)
-- Dependencies: 440 440
-- Name: queue_pkey; Type: CONSTRAINT; Schema: waitingroom; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY queue
    ADD CONSTRAINT queue_pkey PRIMARY KEY (id);


--
-- TOC entry 3444 (class 2606 OID 18709)
-- Dependencies: 438 438
-- Name: room_pkey; Type: CONSTRAINT; Schema: waitingroom; Owner: gecamed; Tablespace: 
--

ALTER TABLE ONLY room
    ADD CONSTRAINT room_pkey PRIMARY KEY (id);


SET search_path = address, pg_catalog;

--
-- TOC entry 3466 (class 2606 OID 16588)
-- Dependencies: 213 3148 215
-- Name: fkcanton; Type: FK CONSTRAINT; Schema: address; Owner: gecamed
--

ALTER TABLE ONLY municipality
    ADD CONSTRAINT fkcanton FOREIGN KEY (canton_id) REFERENCES canton(id) ON DELETE CASCADE;


--
-- TOC entry 3468 (class 2606 OID 16614)
-- Dependencies: 3152 217 219
-- Name: fklocality; Type: FK CONSTRAINT; Schema: address; Owner: gecamed
--

ALTER TABLE ONLY zip
    ADD CONSTRAINT fklocality FOREIGN KEY (locality_id) REFERENCES locality(id) ON DELETE CASCADE;


--
-- TOC entry 3467 (class 2606 OID 16601)
-- Dependencies: 215 217 3150
-- Name: fkmunicipality; Type: FK CONSTRAINT; Schema: address; Owner: gecamed
--

ALTER TABLE ONLY locality
    ADD CONSTRAINT fkmunicipality FOREIGN KEY (municipality_id) REFERENCES municipality(id) ON DELETE CASCADE;


SET search_path = addressbook, pg_catalog;

--
-- TOC entry 3621 (class 2606 OID 18439)
-- Dependencies: 405 407 3400
-- Name: fk_addressbook_contact_address_id; Type: FK CONSTRAINT; Schema: addressbook; Owner: gecamed
--

ALTER TABLE ONLY contact_address
    ADD CONSTRAINT fk_addressbook_contact_address_id FOREIGN KEY (contact_id) REFERENCES contact(id) ON DELETE CASCADE;


--
-- TOC entry 3620 (class 2606 OID 18444)
-- Dependencies: 3152 407 217
-- Name: fk_addressbook_contact_address_locality_id; Type: FK CONSTRAINT; Schema: addressbook; Owner: gecamed
--

ALTER TABLE ONLY contact_address
    ADD CONSTRAINT fk_addressbook_contact_address_locality_id FOREIGN KEY (locality_id) REFERENCES address.locality(id);


SET search_path = agenda, pg_catalog;

--
-- TOC entry 3614 (class 2606 OID 18319)
-- Dependencies: 395 3378 391
-- Name: fk_appoint_calendar; Type: FK CONSTRAINT; Schema: agenda; Owner: gecamed
--

ALTER TABLE ONLY appointment
    ADD CONSTRAINT fk_appoint_calendar FOREIGN KEY (calendar_id) REFERENCES calendar(id) ON DELETE CASCADE;


--
-- TOC entry 3612 (class 2606 OID 18329)
-- Dependencies: 3169 395 229
-- Name: fk_appoint_created_by; Type: FK CONSTRAINT; Schema: agenda; Owner: gecamed
--

ALTER TABLE ONLY appointment
    ADD CONSTRAINT fk_appoint_created_by FOREIGN KEY (created_by) REFERENCES usermanagement.gecamed_user(id);


--
-- TOC entry 3613 (class 2606 OID 18324)
-- Dependencies: 3206 257 395
-- Name: fk_appoint_patient; Type: FK CONSTRAINT; Schema: agenda; Owner: gecamed
--

ALTER TABLE ONLY appointment
    ADD CONSTRAINT fk_appoint_patient FOREIGN KEY (patient_id) REFERENCES patient.patient(id) ON DELETE CASCADE;


--
-- TOC entry 3611 (class 2606 OID 18334)
-- Dependencies: 393 3380 395
-- Name: fk_appointment_appointment_type; Type: FK CONSTRAINT; Schema: agenda; Owner: gecamed
--

ALTER TABLE ONLY appointment
    ADD CONSTRAINT fk_appointment_appointment_type FOREIGN KEY (type_id) REFERENCES appointment_type(id);


--
-- TOC entry 3610 (class 2606 OID 18301)
-- Dependencies: 3378 393 391
-- Name: fk_appointment_type_calendar; Type: FK CONSTRAINT; Schema: agenda; Owner: gecamed
--

ALTER TABLE ONLY appointment_type
    ADD CONSTRAINT fk_appointment_type_calendar FOREIGN KEY (calendar_id) REFERENCES calendar(id) ON DELETE CASCADE;


--
-- TOC entry 3609 (class 2606 OID 18276)
-- Dependencies: 3169 391 229
-- Name: fk_calendar_created_by; Type: FK CONSTRAINT; Schema: agenda; Owner: gecamed
--

ALTER TABLE ONLY calendar
    ADD CONSTRAINT fk_calendar_created_by FOREIGN KEY (created_by) REFERENCES usermanagement.gecamed_user(id);


--
-- TOC entry 3616 (class 2606 OID 18347)
-- Dependencies: 229 397 3169
-- Name: fk_calendar_created_by; Type: FK CONSTRAINT; Schema: agenda; Owner: gecamed
--

ALTER TABLE ONLY rel_user_calendar_selection
    ADD CONSTRAINT fk_calendar_created_by FOREIGN KEY (user_id) REFERENCES usermanagement.gecamed_user(id) ON DELETE CASCADE;


--
-- TOC entry 3607 (class 2606 OID 18286)
-- Dependencies: 3189 247 391
-- Name: fk_calendar_physician; Type: FK CONSTRAINT; Schema: agenda; Owner: gecamed
--

ALTER TABLE ONLY calendar
    ADD CONSTRAINT fk_calendar_physician FOREIGN KEY (physician_id) REFERENCES office.physician(id) ON DELETE CASCADE;


--
-- TOC entry 3608 (class 2606 OID 18281)
-- Dependencies: 391 3169 229
-- Name: fk_calendar_user; Type: FK CONSTRAINT; Schema: agenda; Owner: gecamed
--

ALTER TABLE ONLY calendar
    ADD CONSTRAINT fk_calendar_user FOREIGN KEY (user_id) REFERENCES usermanagement.gecamed_user(id);


--
-- TOC entry 3615 (class 2606 OID 18352)
-- Dependencies: 3378 391 397
-- Name: fk_calendar_user; Type: FK CONSTRAINT; Schema: agenda; Owner: gecamed
--

ALTER TABLE ONLY rel_user_calendar_selection
    ADD CONSTRAINT fk_calendar_user FOREIGN KEY (calendar_id) REFERENCES calendar(id) ON DELETE CASCADE;


SET search_path = billing, pg_catalog;

--
-- TOC entry 3559 (class 2606 OID 17775)
-- Dependencies: 247 348 3189
-- Name: fk_account_holder; Type: FK CONSTRAINT; Schema: billing; Owner: gecamed
--

ALTER TABLE ONLY account
    ADD CONSTRAINT fk_account_holder FOREIGN KEY (holder_id) REFERENCES office.physician(id) ON DELETE CASCADE;


--
-- TOC entry 3586 (class 2606 OID 18059)
-- Dependencies: 374 372 3360
-- Name: fk_act_invoice; Type: FK CONSTRAINT; Schema: billing; Owner: gecamed
--

ALTER TABLE ONLY act
    ADD CONSTRAINT fk_act_invoice FOREIGN KEY (invoice_id) REFERENCES invoice(id) ON DELETE CASCADE;


--
-- TOC entry 3585 (class 2606 OID 18064)
-- Dependencies: 374 247 3189
-- Name: fk_act_physician; Type: FK CONSTRAINT; Schema: billing; Owner: gecamed
--

ALTER TABLE ONLY act
    ADD CONSTRAINT fk_act_physician FOREIGN KEY (physician_id) REFERENCES office.physician(id) ON DELETE CASCADE;


--
-- TOC entry 3555 (class 2606 OID 17728)
-- Dependencies: 3152 342 217
-- Name: fk_bailiff_locality_id; Type: FK CONSTRAINT; Schema: billing; Owner: gecamed
--

ALTER TABLE ONLY bailiff_address
    ADD CONSTRAINT fk_bailiff_locality_id FOREIGN KEY (locality_id) REFERENCES address.locality(id);


--
-- TOC entry 3558 (class 2606 OID 17762)
-- Dependencies: 3322 346 340
-- Name: fk_bailiff_rate_id; Type: FK CONSTRAINT; Schema: billing; Owner: gecamed
--

ALTER TABLE ONLY bailiff_rate
    ADD CONSTRAINT fk_bailiff_rate_id FOREIGN KEY (bailiff_id) REFERENCES bailiff(id) ON DELETE CASCADE;


--
-- TOC entry 3562 (class 2606 OID 17843)
-- Dependencies: 358 3340 358
-- Name: fk_index_parent; Type: FK CONSTRAINT; Schema: billing; Owner: gecamed
--

ALTER TABLE ONLY rate_index
    ADD CONSTRAINT fk_index_parent FOREIGN KEY (parent_id) REFERENCES rate_index(id) ON DELETE CASCADE;


--
-- TOC entry 3581 (class 2606 OID 18001)
-- Dependencies: 3216 265 372
-- Name: fk_invoice_class; Type: FK CONSTRAINT; Schema: billing; Owner: gecamed
--

ALTER TABLE ONLY invoice
    ADD CONSTRAINT fk_invoice_class FOREIGN KEY (class_id) REFERENCES patient.hospitalisation_class(id);


--
-- TOC entry 3576 (class 2606 OID 18026)
-- Dependencies: 372 229 3169
-- Name: fk_invoice_closer; Type: FK CONSTRAINT; Schema: billing; Owner: gecamed
--

ALTER TABLE ONLY invoice
    ADD CONSTRAINT fk_invoice_closer FOREIGN KEY (closer_id) REFERENCES usermanagement.gecamed_user(id) ON DELETE SET NULL;


--
-- TOC entry 3582 (class 2606 OID 17996)
-- Dependencies: 269 372 3220
-- Name: fk_invoice_hospitalisation; Type: FK CONSTRAINT; Schema: billing; Owner: gecamed
--

ALTER TABLE ONLY invoice
    ADD CONSTRAINT fk_invoice_hospitalisation FOREIGN KEY (hospitalisation_id) REFERENCES patient.hospitalisation(id) ON DELETE SET NULL;


--
-- TOC entry 3580 (class 2606 OID 18006)
-- Dependencies: 3195 253 372
-- Name: fk_invoice_insurance; Type: FK CONSTRAINT; Schema: billing; Owner: gecamed
--

ALTER TABLE ONLY invoice
    ADD CONSTRAINT fk_invoice_insurance FOREIGN KEY (insurance_id) REFERENCES patient.insurance(id);


--
-- TOC entry 3575 (class 2606 OID 18031)
-- Dependencies: 372 229 3169
-- Name: fk_invoice_modifier; Type: FK CONSTRAINT; Schema: billing; Owner: gecamed
--

ALTER TABLE ONLY invoice
    ADD CONSTRAINT fk_invoice_modifier FOREIGN KEY (modifier_id) REFERENCES usermanagement.gecamed_user(id) ON DELETE SET NULL;


--
-- TOC entry 3584 (class 2606 OID 17986)
-- Dependencies: 257 3206 372
-- Name: fk_invoice_patient; Type: FK CONSTRAINT; Schema: billing; Owner: gecamed
--

ALTER TABLE ONLY invoice
    ADD CONSTRAINT fk_invoice_patient FOREIGN KEY (patient_id) REFERENCES patient.patient(id) ON DELETE CASCADE;


--
-- TOC entry 3583 (class 2606 OID 17991)
-- Dependencies: 3189 372 247
-- Name: fk_invoice_physician; Type: FK CONSTRAINT; Schema: billing; Owner: gecamed
--

ALTER TABLE ONLY invoice
    ADD CONSTRAINT fk_invoice_physician FOREIGN KEY (physician_id) REFERENCES office.physician(id) ON DELETE CASCADE;


--
-- TOC entry 3578 (class 2606 OID 18016)
-- Dependencies: 372 352 3334
-- Name: fk_invoice_settlement; Type: FK CONSTRAINT; Schema: billing; Owner: gecamed
--

ALTER TABLE ONLY invoice
    ADD CONSTRAINT fk_invoice_settlement FOREIGN KEY (settlement_id) REFERENCES settlement(id);


--
-- TOC entry 3574 (class 2606 OID 18036)
-- Dependencies: 372 251 3193
-- Name: fk_invoice_site_id; Type: FK CONSTRAINT; Schema: billing; Owner: gecamed
--

ALTER TABLE ONLY invoice
    ADD CONSTRAINT fk_invoice_site_id FOREIGN KEY (site_id) REFERENCES office.site(id);


--
-- TOC entry 3577 (class 2606 OID 18021)
-- Dependencies: 372 366 3353
-- Name: fk_invoice_statement; Type: FK CONSTRAINT; Schema: billing; Owner: gecamed
--

ALTER TABLE ONLY invoice
    ADD CONSTRAINT fk_invoice_statement FOREIGN KEY (statement_id) REFERENCES statement(id) ON DELETE SET NULL;


--
-- TOC entry 3579 (class 2606 OID 18011)
-- Dependencies: 253 372 3195
-- Name: fk_invoice_thirdparty; Type: FK CONSTRAINT; Schema: billing; Owner: gecamed
--

ALTER TABLE ONLY invoice
    ADD CONSTRAINT fk_invoice_thirdparty FOREIGN KEY (third_party_id) REFERENCES patient.insurance(id);


--
-- TOC entry 3605 (class 2606 OID 18221)
-- Dependencies: 3169 383 229
-- Name: fk_ledger_cashier; Type: FK CONSTRAINT; Schema: billing; Owner: gecamed
--

ALTER TABLE ONLY ledger
    ADD CONSTRAINT fk_ledger_cashier FOREIGN KEY (cashier_id) REFERENCES usermanagement.gecamed_user(id);


--
-- TOC entry 3606 (class 2606 OID 18216)
-- Dependencies: 383 3360 372
-- Name: fk_ledger_invoice; Type: FK CONSTRAINT; Schema: billing; Owner: gecamed
--

ALTER TABLE ONLY ledger
    ADD CONSTRAINT fk_ledger_invoice FOREIGN KEY (invoice_id) REFERENCES invoice(id) ON DELETE SET NULL;


--
-- TOC entry 3604 (class 2606 OID 18226)
-- Dependencies: 3334 352 383
-- Name: fk_ledger_settlement; Type: FK CONSTRAINT; Schema: billing; Owner: gecamed
--

ALTER TABLE ONLY ledger
    ADD CONSTRAINT fk_ledger_settlement FOREIGN KEY (settlement_id) REFERENCES settlement(id);


--
-- TOC entry 3587 (class 2606 OID 18086)
-- Dependencies: 376 229 3169
-- Name: fk_memo_author; Type: FK CONSTRAINT; Schema: billing; Owner: gecamed
--

ALTER TABLE ONLY memo
    ADD CONSTRAINT fk_memo_author FOREIGN KEY (author_id) REFERENCES usermanagement.gecamed_user(id);


--
-- TOC entry 3588 (class 2606 OID 18081)
-- Dependencies: 376 372 3360
-- Name: fk_memo_invoice; Type: FK CONSTRAINT; Schema: billing; Owner: gecamed
--

ALTER TABLE ONLY memo
    ADD CONSTRAINT fk_memo_invoice FOREIGN KEY (invoice_id) REFERENCES invoice(id) ON DELETE CASCADE;


--
-- TOC entry 3563 (class 2606 OID 17870)
-- Dependencies: 3340 360 358
-- Name: fk_rate_index; Type: FK CONSTRAINT; Schema: billing; Owner: gecamed
--

ALTER TABLE ONLY rate
    ADD CONSTRAINT fk_rate_index FOREIGN KEY (index_id) REFERENCES rate_index(id) ON DELETE CASCADE;


--
-- TOC entry 3564 (class 2606 OID 17865)
-- Dependencies: 354 3336 360
-- Name: fk_rate_keyvalue; Type: FK CONSTRAINT; Schema: billing; Owner: gecamed
--

ALTER TABLE ONLY rate
    ADD CONSTRAINT fk_rate_keyvalue FOREIGN KEY (key_value_id) REFERENCES key_value(id) ON DELETE CASCADE;


--
-- TOC entry 3556 (class 2606 OID 17746)
-- Dependencies: 340 3322 344
-- Name: fk_rel_municipality_bailiff_bailiff; Type: FK CONSTRAINT; Schema: billing; Owner: gecamed
--

ALTER TABLE ONLY rel_municipality_bailiff
    ADD CONSTRAINT fk_rel_municipality_bailiff_bailiff FOREIGN KEY (bailiff_id) REFERENCES bailiff(id) ON DELETE CASCADE;


--
-- TOC entry 3557 (class 2606 OID 17741)
-- Dependencies: 3150 344 215
-- Name: fk_rel_municipality_bailiff_municipality; Type: FK CONSTRAINT; Schema: billing; Owner: gecamed
--

ALTER TABLE ONLY rel_municipality_bailiff
    ADD CONSTRAINT fk_rel_municipality_bailiff_municipality FOREIGN KEY (municipality_id) REFERENCES address.municipality(id) ON DELETE CASCADE;


--
-- TOC entry 3570 (class 2606 OID 17946)
-- Dependencies: 368 3195 253
-- Name: fk_rel_statement_insurance_insurance; Type: FK CONSTRAINT; Schema: billing; Owner: gecamed
--

ALTER TABLE ONLY rel_statement_insurance
    ADD CONSTRAINT fk_rel_statement_insurance_insurance FOREIGN KEY (insurance_id) REFERENCES patient.insurance(id) ON DELETE CASCADE;


--
-- TOC entry 3571 (class 2606 OID 17941)
-- Dependencies: 366 368 3353
-- Name: fk_rel_statement_insurance_statement; Type: FK CONSTRAINT; Schema: billing; Owner: gecamed
--

ALTER TABLE ONLY rel_statement_insurance
    ADD CONSTRAINT fk_rel_statement_insurance_statement FOREIGN KEY (statement_id) REFERENCES statement(id) ON DELETE CASCADE;


--
-- TOC entry 3572 (class 2606 OID 17964)
-- Dependencies: 370 247 3189
-- Name: fk_rel_statement_physician_physician; Type: FK CONSTRAINT; Schema: billing; Owner: gecamed
--

ALTER TABLE ONLY rel_statement_physician
    ADD CONSTRAINT fk_rel_statement_physician_physician FOREIGN KEY (physician_id) REFERENCES office.physician(id) ON DELETE CASCADE;


--
-- TOC entry 3573 (class 2606 OID 17959)
-- Dependencies: 3353 370 366
-- Name: fk_rel_statement_physician_statement; Type: FK CONSTRAINT; Schema: billing; Owner: gecamed
--

ALTER TABLE ONLY rel_statement_physician
    ADD CONSTRAINT fk_rel_statement_physician_statement FOREIGN KEY (statement_id) REFERENCES statement(id) ON DELETE CASCADE;


--
-- TOC entry 3566 (class 2606 OID 17908)
-- Dependencies: 360 364 3345
-- Name: fk_rel_template_rate_rate; Type: FK CONSTRAINT; Schema: billing; Owner: gecamed
--

ALTER TABLE ONLY rel_template_rate
    ADD CONSTRAINT fk_rel_template_rate_rate FOREIGN KEY (rate_id) REFERENCES rate(id) ON DELETE CASCADE;


--
-- TOC entry 3567 (class 2606 OID 17903)
-- Dependencies: 362 3349 364
-- Name: fk_rel_template_rate_template; Type: FK CONSTRAINT; Schema: billing; Owner: gecamed
--

ALTER TABLE ONLY rel_template_rate
    ADD CONSTRAINT fk_rel_template_rate_template FOREIGN KEY (template_id) REFERENCES template(id) ON DELETE CASCADE;


--
-- TOC entry 3561 (class 2606 OID 17796)
-- Dependencies: 352 3330 348
-- Name: fk_settlement_account; Type: FK CONSTRAINT; Schema: billing; Owner: gecamed
--

ALTER TABLE ONLY settlement
    ADD CONSTRAINT fk_settlement_account FOREIGN KEY (account_id) REFERENCES account(id) ON DELETE CASCADE;


--
-- TOC entry 3560 (class 2606 OID 17801)
-- Dependencies: 352 3332 350
-- Name: fk_settlement_payment; Type: FK CONSTRAINT; Schema: billing; Owner: gecamed
--

ALTER TABLE ONLY settlement
    ADD CONSTRAINT fk_settlement_payment FOREIGN KEY (payment_id) REFERENCES payment(id) ON DELETE CASCADE;


--
-- TOC entry 3568 (class 2606 OID 17928)
-- Dependencies: 348 3330 366
-- Name: fk_statement_account; Type: FK CONSTRAINT; Schema: billing; Owner: gecamed
--

ALTER TABLE ONLY statement
    ADD CONSTRAINT fk_statement_account FOREIGN KEY (account_id) REFERENCES account(id);


--
-- TOC entry 3569 (class 2606 OID 17923)
-- Dependencies: 3169 366 229
-- Name: fk_statement_closer; Type: FK CONSTRAINT; Schema: billing; Owner: gecamed
--

ALTER TABLE ONLY statement
    ADD CONSTRAINT fk_statement_closer FOREIGN KEY (closer_id) REFERENCES usermanagement.gecamed_user(id);


--
-- TOC entry 3565 (class 2606 OID 17890)
-- Dependencies: 362 229 3169
-- Name: fk_template_user; Type: FK CONSTRAINT; Schema: billing; Owner: gecamed
--

ALTER TABLE ONLY template
    ADD CONSTRAINT fk_template_user FOREIGN KEY (user_id) REFERENCES usermanagement.gecamed_user(id);


--
-- TOC entry 3601 (class 2606 OID 18176)
-- Dependencies: 377 3368 379
-- Name: fk_trashed_act_invoice; Type: FK CONSTRAINT; Schema: billing; Owner: gecamed
--

ALTER TABLE ONLY trashed_act
    ADD CONSTRAINT fk_trashed_act_invoice FOREIGN KEY (invoice_id) REFERENCES trashed_invoice(id) ON DELETE CASCADE;


--
-- TOC entry 3600 (class 2606 OID 18181)
-- Dependencies: 247 379 3189
-- Name: fk_trashed_act_physician; Type: FK CONSTRAINT; Schema: billing; Owner: gecamed
--

ALTER TABLE ONLY trashed_act
    ADD CONSTRAINT fk_trashed_act_physician FOREIGN KEY (physician_id) REFERENCES office.physician(id) ON DELETE SET NULL;


--
-- TOC entry 3596 (class 2606 OID 18120)
-- Dependencies: 377 265 3216
-- Name: fk_trashed_invoice_class; Type: FK CONSTRAINT; Schema: billing; Owner: gecamed
--

ALTER TABLE ONLY trashed_invoice
    ADD CONSTRAINT fk_trashed_invoice_class FOREIGN KEY (class_id) REFERENCES patient.hospitalisation_class(id);


--
-- TOC entry 3591 (class 2606 OID 18145)
-- Dependencies: 229 377 3169
-- Name: fk_trashed_invoice_closer; Type: FK CONSTRAINT; Schema: billing; Owner: gecamed
--

ALTER TABLE ONLY trashed_invoice
    ADD CONSTRAINT fk_trashed_invoice_closer FOREIGN KEY (closer_id) REFERENCES usermanagement.gecamed_user(id) ON DELETE SET NULL;


--
-- TOC entry 3597 (class 2606 OID 18115)
-- Dependencies: 377 269 3220
-- Name: fk_trashed_invoice_hospitalisation; Type: FK CONSTRAINT; Schema: billing; Owner: gecamed
--

ALTER TABLE ONLY trashed_invoice
    ADD CONSTRAINT fk_trashed_invoice_hospitalisation FOREIGN KEY (hospitalisation_id) REFERENCES patient.hospitalisation(id);


--
-- TOC entry 3595 (class 2606 OID 18125)
-- Dependencies: 377 3195 253
-- Name: fk_trashed_invoice_insurance; Type: FK CONSTRAINT; Schema: billing; Owner: gecamed
--

ALTER TABLE ONLY trashed_invoice
    ADD CONSTRAINT fk_trashed_invoice_insurance FOREIGN KEY (insurance_id) REFERENCES patient.insurance(id);


--
-- TOC entry 3590 (class 2606 OID 18150)
-- Dependencies: 377 229 3169
-- Name: fk_trashed_invoice_modifier; Type: FK CONSTRAINT; Schema: billing; Owner: gecamed
--

ALTER TABLE ONLY trashed_invoice
    ADD CONSTRAINT fk_trashed_invoice_modifier FOREIGN KEY (modifier_id) REFERENCES usermanagement.gecamed_user(id) ON DELETE SET NULL;


--
-- TOC entry 3599 (class 2606 OID 18105)
-- Dependencies: 377 257 3206
-- Name: fk_trashed_invoice_patient; Type: FK CONSTRAINT; Schema: billing; Owner: gecamed
--

ALTER TABLE ONLY trashed_invoice
    ADD CONSTRAINT fk_trashed_invoice_patient FOREIGN KEY (patient_id) REFERENCES patient.patient(id) ON DELETE SET NULL;


--
-- TOC entry 3598 (class 2606 OID 18110)
-- Dependencies: 377 247 3189
-- Name: fk_trashed_invoice_physician; Type: FK CONSTRAINT; Schema: billing; Owner: gecamed
--

ALTER TABLE ONLY trashed_invoice
    ADD CONSTRAINT fk_trashed_invoice_physician FOREIGN KEY (physician_id) REFERENCES office.physician(id) ON DELETE SET NULL;


--
-- TOC entry 3593 (class 2606 OID 18135)
-- Dependencies: 377 3334 352
-- Name: fk_trashed_invoice_settlement; Type: FK CONSTRAINT; Schema: billing; Owner: gecamed
--

ALTER TABLE ONLY trashed_invoice
    ADD CONSTRAINT fk_trashed_invoice_settlement FOREIGN KEY (settlement_id) REFERENCES settlement(id);


--
-- TOC entry 3592 (class 2606 OID 18140)
-- Dependencies: 3353 366 377
-- Name: fk_trashed_invoice_statement; Type: FK CONSTRAINT; Schema: billing; Owner: gecamed
--

ALTER TABLE ONLY trashed_invoice
    ADD CONSTRAINT fk_trashed_invoice_statement FOREIGN KEY (statement_id) REFERENCES statement(id) ON DELETE SET NULL;


--
-- TOC entry 3594 (class 2606 OID 18130)
-- Dependencies: 253 3195 377
-- Name: fk_trashed_invoice_thirdparty; Type: FK CONSTRAINT; Schema: billing; Owner: gecamed
--

ALTER TABLE ONLY trashed_invoice
    ADD CONSTRAINT fk_trashed_invoice_thirdparty FOREIGN KEY (third_party_id) REFERENCES patient.insurance(id);


--
-- TOC entry 3589 (class 2606 OID 18155)
-- Dependencies: 377 229 3169
-- Name: fk_trashed_invoice_trasher; Type: FK CONSTRAINT; Schema: billing; Owner: gecamed
--

ALTER TABLE ONLY trashed_invoice
    ADD CONSTRAINT fk_trashed_invoice_trasher FOREIGN KEY (trasher_id) REFERENCES usermanagement.gecamed_user(id) ON DELETE SET NULL;


--
-- TOC entry 3602 (class 2606 OID 18202)
-- Dependencies: 229 381 3169
-- Name: fk_trashed_memo_author; Type: FK CONSTRAINT; Schema: billing; Owner: gecamed
--

ALTER TABLE ONLY trashed_memo
    ADD CONSTRAINT fk_trashed_memo_author FOREIGN KEY (author_id) REFERENCES usermanagement.gecamed_user(id) ON DELETE SET NULL;


--
-- TOC entry 3603 (class 2606 OID 18197)
-- Dependencies: 3368 381 377
-- Name: fk_trashed_memo_invoice; Type: FK CONSTRAINT; Schema: billing; Owner: gecamed
--

ALTER TABLE ONLY trashed_memo
    ADD CONSTRAINT fk_trashed_memo_invoice FOREIGN KEY (invoice_id) REFERENCES trashed_invoice(id) ON DELETE CASCADE;


SET search_path = core, pg_catalog;

--
-- TOC entry 3464 (class 2606 OID 16686)
-- Dependencies: 205 229 3169
-- Name: fk_core_autocompletion_user_id; Type: FK CONSTRAINT; Schema: core; Owner: gecamed
--

ALTER TABLE ONLY autocompletion
    ADD CONSTRAINT fk_core_autocompletion_user_id FOREIGN KEY (user_id) REFERENCES usermanagement.gecamed_user(id) ON DELETE SET NULL;


--
-- TOC entry 3465 (class 2606 OID 16841)
-- Dependencies: 247 3189 207
-- Name: fk_core_xsl_templates_physician_id; Type: FK CONSTRAINT; Schema: core; Owner: gecamed
--

ALTER TABLE ONLY xsl_templates
    ADD CONSTRAINT fk_core_xsl_templates_physician_id FOREIGN KEY (physician_id) REFERENCES office.physician(id) ON DELETE CASCADE;


--
-- TOC entry 3463 (class 2606 OID 16510)
-- Dependencies: 197 3133 199
-- Name: fk_log_log_type_id; Type: FK CONSTRAINT; Schema: core; Owner: gecamed
--

ALTER TABLE ONLY log
    ADD CONSTRAINT fk_log_log_type_id FOREIGN KEY (type_id) REFERENCES log_types(id) ON DELETE CASCADE;


SET search_path = dicom, pg_catalog;

--
-- TOC entry 3619 (class 2606 OID 18408)
-- Dependencies: 3394 401 403
-- Name: fk_dicom_image_series; Type: FK CONSTRAINT; Schema: dicom; Owner: gecamed
--

ALTER TABLE ONLY image
    ADD CONSTRAINT fk_dicom_image_series FOREIGN KEY (series_id) REFERENCES series(id) ON DELETE CASCADE;


--
-- TOC entry 3618 (class 2606 OID 18392)
-- Dependencies: 3390 401 399
-- Name: fk_dicom_series_study; Type: FK CONSTRAINT; Schema: dicom; Owner: gecamed
--

ALTER TABLE ONLY series
    ADD CONSTRAINT fk_dicom_series_study FOREIGN KEY (study_id) REFERENCES study(id) ON DELETE CASCADE;


--
-- TOC entry 3617 (class 2606 OID 18376)
-- Dependencies: 399 3206 257
-- Name: fk_dicom_study_patient; Type: FK CONSTRAINT; Schema: dicom; Owner: gecamed
--

ALTER TABLE ONLY study
    ADD CONSTRAINT fk_dicom_study_patient FOREIGN KEY (patient_id) REFERENCES patient.patient(id) ON DELETE CASCADE;


SET search_path = formeditor, pg_catalog;

--
-- TOC entry 3650 (class 2606 OID 18818)
-- Dependencies: 448 3278 301
-- Name: fk_formeditor_form_incident_entry_id; Type: FK CONSTRAINT; Schema: formeditor; Owner: gecamed
--

ALTER TABLE ONLY form
    ADD CONSTRAINT fk_formeditor_form_incident_entry_id FOREIGN KEY (incident_entry_id) REFERENCES patient.incident_entry(id) ON DELETE CASCADE;


--
-- TOC entry 3651 (class 2606 OID 18813)
-- Dependencies: 448 3206 257
-- Name: fk_formeditor_form_patient_id; Type: FK CONSTRAINT; Schema: formeditor; Owner: gecamed
--

ALTER TABLE ONLY form
    ADD CONSTRAINT fk_formeditor_form_patient_id FOREIGN KEY (patient_id) REFERENCES patient.patient(id) ON DELETE CASCADE;


--
-- TOC entry 3649 (class 2606 OID 18823)
-- Dependencies: 3455 448 448
-- Name: fk_formeditor_form_subform_of; Type: FK CONSTRAINT; Schema: formeditor; Owner: gecamed
--

ALTER TABLE ONLY form
    ADD CONSTRAINT fk_formeditor_form_subform_of FOREIGN KEY (subform_of) REFERENCES form(id) ON DELETE CASCADE;


--
-- TOC entry 3652 (class 2606 OID 18808)
-- Dependencies: 446 3453 448
-- Name: fk_formeditor_form_template_id; Type: FK CONSTRAINT; Schema: formeditor; Owner: gecamed
--

ALTER TABLE ONLY form
    ADD CONSTRAINT fk_formeditor_form_template_id FOREIGN KEY (template_id) REFERENCES form_template(id) ON DELETE CASCADE;


--
-- TOC entry 3648 (class 2606 OID 18794)
-- Dependencies: 446 3135 201
-- Name: fk_formeditor_form_template_jasper_template_id; Type: FK CONSTRAINT; Schema: formeditor; Owner: gecamed
--

ALTER TABLE ONLY form_template
    ADD CONSTRAINT fk_formeditor_form_template_jasper_template_id FOREIGN KEY (jasper_template_id) REFERENCES core.templates(id) ON DELETE SET NULL;


--
-- TOC entry 3653 (class 2606 OID 18839)
-- Dependencies: 3455 450 448
-- Name: fk_formeditor_form_value_form_id; Type: FK CONSTRAINT; Schema: formeditor; Owner: gecamed
--

ALTER TABLE ONLY form_value
    ADD CONSTRAINT fk_formeditor_form_value_form_id FOREIGN KEY (form_id) REFERENCES form(id) ON DELETE CASCADE;


SET search_path = labo, pg_catalog;

--
-- TOC entry 3638 (class 2606 OID 18642)
-- Dependencies: 3425 429 423
-- Name: fk_antibiogram_result; Type: FK CONSTRAINT; Schema: labo; Owner: gecamed
--

ALTER TABLE ONLY antibiogram
    ADD CONSTRAINT fk_antibiogram_result FOREIGN KEY (result_id) REFERENCES result(id) ON DELETE CASCADE;


--
-- TOC entry 3631 (class 2606 OID 18561)
-- Dependencies: 421 3181 239
-- Name: fk_connection_office; Type: FK CONSTRAINT; Schema: labo; Owner: gecamed
--

ALTER TABLE ONLY connection
    ADD CONSTRAINT fk_connection_office FOREIGN KEY (office_id) REFERENCES office.office(id) ON DELETE CASCADE;


--
-- TOC entry 3630 (class 2606 OID 18566)
-- Dependencies: 247 3189 421
-- Name: fk_connection_physician; Type: FK CONSTRAINT; Schema: labo; Owner: gecamed
--

ALTER TABLE ONLY connection
    ADD CONSTRAINT fk_connection_physician FOREIGN KEY (physician_id) REFERENCES office.physician(id) ON DELETE CASCADE;


--
-- TOC entry 3626 (class 2606 OID 18498)
-- Dependencies: 411 3407 415
-- Name: fk_labo_address_laboratory; Type: FK CONSTRAINT; Schema: labo; Owner: gecamed
--

ALTER TABLE ONLY labo_address
    ADD CONSTRAINT fk_labo_address_laboratory FOREIGN KEY (laboratory_id) REFERENCES laboratory(id) ON DELETE CASCADE;


--
-- TOC entry 3625 (class 2606 OID 18503)
-- Dependencies: 415 3152 217
-- Name: fk_labo_address_locality; Type: FK CONSTRAINT; Schema: labo; Owner: gecamed
--

ALTER TABLE ONLY labo_address
    ADD CONSTRAINT fk_labo_address_locality FOREIGN KEY (locality_id) REFERENCES address.locality(id);


--
-- TOC entry 3639 (class 2606 OID 18655)
-- Dependencies: 429 431 3433
-- Name: fk_labo_antibiotic_antibiogram; Type: FK CONSTRAINT; Schema: labo; Owner: gecamed
--

ALTER TABLE ONLY antibiotic
    ADD CONSTRAINT fk_labo_antibiotic_antibiogram FOREIGN KEY (antibiogram_id) REFERENCES antibiogram(id) ON DELETE CASCADE;


--
-- TOC entry 3627 (class 2606 OID 18520)
-- Dependencies: 3407 417 411
-- Name: fk_labo_certificate_laboratory; Type: FK CONSTRAINT; Schema: labo; Owner: gecamed
--

ALTER TABLE ONLY labo_certificate
    ADD CONSTRAINT fk_labo_certificate_laboratory FOREIGN KEY (laboratory_id) REFERENCES laboratory(id) ON DELETE CASCADE;


--
-- TOC entry 3640 (class 2606 OID 18668)
-- Dependencies: 3433 433 429
-- Name: fk_labo_culture_antibiogram; Type: FK CONSTRAINT; Schema: labo; Owner: gecamed
--

ALTER TABLE ONLY culture
    ADD CONSTRAINT fk_labo_culture_antibiogram FOREIGN KEY (antibiogram_id) REFERENCES antibiogram(id) ON DELETE CASCADE;


--
-- TOC entry 3641 (class 2606 OID 18681)
-- Dependencies: 435 431 3436
-- Name: fk_labo_reaction_antibiotic; Type: FK CONSTRAINT; Schema: labo; Owner: gecamed
--

ALTER TABLE ONLY reaction
    ADD CONSTRAINT fk_labo_reaction_antibiotic FOREIGN KEY (antibiotic_id) REFERENCES antibiotic(id) ON DELETE CASCADE;


--
-- TOC entry 3622 (class 2606 OID 18459)
-- Dependencies: 409 3181 239
-- Name: fk_masterpassword_office; Type: FK CONSTRAINT; Schema: labo; Owner: gecamed
--

ALTER TABLE ONLY masterpassword
    ADD CONSTRAINT fk_masterpassword_office FOREIGN KEY (office_id) REFERENCES office.office(id) ON DELETE CASCADE;


--
-- TOC entry 3629 (class 2606 OID 18538)
-- Dependencies: 239 419 3181
-- Name: fk_physician_key_office; Type: FK CONSTRAINT; Schema: labo; Owner: gecamed
--

ALTER TABLE ONLY physician_key
    ADD CONSTRAINT fk_physician_key_office FOREIGN KEY (office_id) REFERENCES office.office(id) ON DELETE CASCADE;


--
-- TOC entry 3628 (class 2606 OID 18543)
-- Dependencies: 247 419 3189
-- Name: fk_physician_key_physician; Type: FK CONSTRAINT; Schema: labo; Owner: gecamed
--

ALTER TABLE ONLY physician_key
    ADD CONSTRAINT fk_physician_key_physician FOREIGN KEY (physician_id) REFERENCES office.physician(id) ON DELETE CASCADE;


--
-- TOC entry 3637 (class 2606 OID 18626)
-- Dependencies: 427 423 3425
-- Name: fk_rel_analysis_result; Type: FK CONSTRAINT; Schema: labo; Owner: gecamed
--

ALTER TABLE ONLY analysis
    ADD CONSTRAINT fk_rel_analysis_result FOREIGN KEY (result_id) REFERENCES result(id) ON DELETE CASCADE;


--
-- TOC entry 3623 (class 2606 OID 18485)
-- Dependencies: 413 3400 405
-- Name: fk_rel_laboratory_contact_contact; Type: FK CONSTRAINT; Schema: labo; Owner: gecamed
--

ALTER TABLE ONLY rel_laboratory_contact
    ADD CONSTRAINT fk_rel_laboratory_contact_contact FOREIGN KEY (contact_id) REFERENCES addressbook.contact(id) ON DELETE CASCADE;


--
-- TOC entry 3624 (class 2606 OID 18480)
-- Dependencies: 3407 413 411
-- Name: fk_rel_laboratory_contact_laboratory; Type: FK CONSTRAINT; Schema: labo; Owner: gecamed
--

ALTER TABLE ONLY rel_laboratory_contact
    ADD CONSTRAINT fk_rel_laboratory_contact_laboratory FOREIGN KEY (laboratory_id) REFERENCES laboratory(id) ON DELETE CASCADE;


--
-- TOC entry 3635 (class 2606 OID 18610)
-- Dependencies: 405 425 3400
-- Name: fk_rel_result_contact_contact; Type: FK CONSTRAINT; Schema: labo; Owner: gecamed
--

ALTER TABLE ONLY rel_result_contact
    ADD CONSTRAINT fk_rel_result_contact_contact FOREIGN KEY (contact_id) REFERENCES addressbook.contact(id) ON DELETE CASCADE;


--
-- TOC entry 3636 (class 2606 OID 18605)
-- Dependencies: 425 423 3425
-- Name: fk_rel_result_contact_result; Type: FK CONSTRAINT; Schema: labo; Owner: gecamed
--

ALTER TABLE ONLY rel_result_contact
    ADD CONSTRAINT fk_rel_result_contact_result FOREIGN KEY (result_id) REFERENCES result(id) ON DELETE CASCADE;


--
-- TOC entry 3634 (class 2606 OID 18582)
-- Dependencies: 3407 411 423
-- Name: fk_result_laboratory; Type: FK CONSTRAINT; Schema: labo; Owner: gecamed
--

ALTER TABLE ONLY result
    ADD CONSTRAINT fk_result_laboratory FOREIGN KEY (laboratory_id) REFERENCES laboratory(id) ON DELETE SET NULL;


--
-- TOC entry 3632 (class 2606 OID 18592)
-- Dependencies: 257 3206 423
-- Name: fk_result_patient; Type: FK CONSTRAINT; Schema: labo; Owner: gecamed
--

ALTER TABLE ONLY result
    ADD CONSTRAINT fk_result_patient FOREIGN KEY (patient_id) REFERENCES patient.patient(id) ON DELETE CASCADE;


--
-- TOC entry 3633 (class 2606 OID 18587)
-- Dependencies: 3189 423 247
-- Name: fk_result_prescriber; Type: FK CONSTRAINT; Schema: labo; Owner: gecamed
--

ALTER TABLE ONLY result
    ADD CONSTRAINT fk_result_prescriber FOREIGN KEY (prescriber_id) REFERENCES office.physician(id) ON DELETE CASCADE;


SET search_path = letter, pg_catalog;

--
-- TOC entry 3647 (class 2606 OID 18773)
-- Dependencies: 301 444 3278
-- Name: fk_incident_entry; Type: FK CONSTRAINT; Schema: letter; Owner: gecamed
--

ALTER TABLE ONLY letters
    ADD CONSTRAINT fk_incident_entry FOREIGN KEY (incident_entry_id) REFERENCES patient.incident_entry(id) ON DELETE CASCADE;


SET search_path = office, pg_catalog;

--
-- TOC entry 3479 (class 2606 OID 16802)
-- Dependencies: 217 243 3152
-- Name: fk_office_address_locality_id; Type: FK CONSTRAINT; Schema: office; Owner: gecamed
--

ALTER TABLE ONLY office_address
    ADD CONSTRAINT fk_office_address_locality_id FOREIGN KEY (locality_id) REFERENCES address.locality(id);


--
-- TOC entry 3480 (class 2606 OID 16797)
-- Dependencies: 239 243 3181
-- Name: fk_office_address_office_id; Type: FK CONSTRAINT; Schema: office; Owner: gecamed
--

ALTER TABLE ONLY office_address
    ADD CONSTRAINT fk_office_address_office_id FOREIGN KEY (office_id) REFERENCES office(id);


--
-- TOC entry 3478 (class 2606 OID 16784)
-- Dependencies: 3181 241 239
-- Name: fk_office_phone_office_id; Type: FK CONSTRAINT; Schema: office; Owner: gecamed
--

ALTER TABLE ONLY office_phone
    ADD CONSTRAINT fk_office_phone_office_id FOREIGN KEY (office_id) REFERENCES office(id);


--
-- TOC entry 3481 (class 2606 OID 16815)
-- Dependencies: 217 3152 245
-- Name: fk_physician_address_locality_id; Type: FK CONSTRAINT; Schema: office; Owner: gecamed
--

ALTER TABLE ONLY physician_address
    ADD CONSTRAINT fk_physician_address_locality_id FOREIGN KEY (locality_id) REFERENCES address.locality(id);


--
-- TOC entry 3482 (class 2606 OID 16836)
-- Dependencies: 245 3187 247
-- Name: fk_physician_address_physician_id; Type: FK CONSTRAINT; Schema: office; Owner: gecamed
--

ALTER TABLE ONLY physician
    ADD CONSTRAINT fk_physician_address_physician_id FOREIGN KEY (address_id) REFERENCES physician_address(id);


--
-- TOC entry 3484 (class 2606 OID 16854)
-- Dependencies: 249 217 3152
-- Name: fk_site_address_locality_id; Type: FK CONSTRAINT; Schema: office; Owner: gecamed
--

ALTER TABLE ONLY site_address
    ADD CONSTRAINT fk_site_address_locality_id FOREIGN KEY (locality_id) REFERENCES address.locality(id);


--
-- TOC entry 3485 (class 2606 OID 16870)
-- Dependencies: 3181 239 251
-- Name: fk_site_office_id; Type: FK CONSTRAINT; Schema: office; Owner: gecamed
--

ALTER TABLE ONLY site
    ADD CONSTRAINT fk_site_office_id FOREIGN KEY (office_id) REFERENCES office(id);


--
-- TOC entry 3483 (class 2606 OID 16831)
-- Dependencies: 247 229 3169
-- Name: fkphysician_userid; Type: FK CONSTRAINT; Schema: office; Owner: gecamed
--

ALTER TABLE ONLY physician
    ADD CONSTRAINT fkphysician_userid FOREIGN KEY (user_id) REFERENCES usermanagement.gecamed_user(id) ON DELETE CASCADE;


SET search_path = patient, pg_catalog;

--
-- TOC entry 3513 (class 2606 OID 17348)
-- Dependencies: 257 289 3206
-- Name: fk_allergies_patient; Type: FK CONSTRAINT; Schema: patient; Owner: gecamed
--

ALTER TABLE ONLY allergies
    ADD CONSTRAINT fk_allergies_patient FOREIGN KEY (patient_id) REFERENCES patient(id) ON DELETE CASCADE;


--
-- TOC entry 3517 (class 2606 OID 17214)
-- Dependencies: 3169 291 229
-- Name: fk_antecedent_lock; Type: FK CONSTRAINT; Schema: patient; Owner: gecamed
--

ALTER TABLE ONLY antecedents
    ADD CONSTRAINT fk_antecedent_lock FOREIGN KEY (locked_by) REFERENCES usermanagement.gecamed_user(id);


--
-- TOC entry 3516 (class 2606 OID 17353)
-- Dependencies: 229 291 3169
-- Name: fk_antecedents_gecamed_user; Type: FK CONSTRAINT; Schema: patient; Owner: gecamed
--

ALTER TABLE ONLY antecedents
    ADD CONSTRAINT fk_antecedents_gecamed_user FOREIGN KEY (created_by) REFERENCES usermanagement.gecamed_user(id);


--
-- TOC entry 3515 (class 2606 OID 17358)
-- Dependencies: 3169 291 229
-- Name: fk_antecedents_gecamed_user_delete; Type: FK CONSTRAINT; Schema: patient; Owner: gecamed
--

ALTER TABLE ONLY antecedents
    ADD CONSTRAINT fk_antecedents_gecamed_user_delete FOREIGN KEY (deleted_by) REFERENCES usermanagement.gecamed_user(id);


--
-- TOC entry 3514 (class 2606 OID 17363)
-- Dependencies: 291 257 3206
-- Name: fk_antecedents_patient; Type: FK CONSTRAINT; Schema: patient; Owner: gecamed
--

ALTER TABLE ONLY antecedents
    ADD CONSTRAINT fk_antecedents_patient FOREIGN KEY (patient_id) REFERENCES patient(id) ON DELETE CASCADE;


--
-- TOC entry 3520 (class 2606 OID 17368)
-- Dependencies: 3273 293 297
-- Name: fk_consultations_visits; Type: FK CONSTRAINT; Schema: patient; Owner: gecamed
--

ALTER TABLE ONLY consultations
    ADD CONSTRAINT fk_consultations_visits FOREIGN KEY (incident_id) REFERENCES incidents(id) ON DELETE CASCADE;


--
-- TOC entry 3505 (class 2606 OID 17127)
-- Dependencies: 3152 217 281
-- Name: fk_file_locality_id; Type: FK CONSTRAINT; Schema: patient; Owner: gecamed
--

ALTER TABLE ONLY patient_address
    ADD CONSTRAINT fk_file_locality_id FOREIGN KEY (locality_id) REFERENCES address.locality(id);


--
-- TOC entry 3506 (class 2606 OID 17122)
-- Dependencies: 3206 281 257
-- Name: fk_file_patient_id; Type: FK CONSTRAINT; Schema: patient; Owner: gecamed
--

ALTER TABLE ONLY patient_address
    ADD CONSTRAINT fk_file_patient_id FOREIGN KEY (patient_id) REFERENCES patient(id) ON DELETE CASCADE;


--
-- TOC entry 3497 (class 2606 OID 17036)
-- Dependencies: 273 3225 271
-- Name: fk_hospital_prescription_hospitalisation_period; Type: FK CONSTRAINT; Schema: patient; Owner: gecamed
--

ALTER TABLE ONLY hospital_prescription
    ADD CONSTRAINT fk_hospital_prescription_hospitalisation_period FOREIGN KEY (hospperiod_id) REFERENCES hospitalisation_period(id) ON DELETE CASCADE;


--
-- TOC entry 3498 (class 2606 OID 17053)
-- Dependencies: 3228 273 275
-- Name: fk_hospital_prescription_page; Type: FK CONSTRAINT; Schema: patient; Owner: gecamed
--

ALTER TABLE ONLY hospital_prescription_page
    ADD CONSTRAINT fk_hospital_prescription_page FOREIGN KEY (hospprescription_id) REFERENCES hospital_prescription(id) ON DELETE CASCADE;


--
-- TOC entry 3499 (class 2606 OID 17070)
-- Dependencies: 3228 273 277
-- Name: fk_hospital_report_hospital_prescription; Type: FK CONSTRAINT; Schema: patient; Owner: gecamed
--

ALTER TABLE ONLY hospital_report
    ADD CONSTRAINT fk_hospital_report_hospital_prescription FOREIGN KEY (hospprescription_id) REFERENCES hospital_prescription(id) ON DELETE CASCADE;


--
-- TOC entry 3492 (class 2606 OID 16991)
-- Dependencies: 3206 257 269
-- Name: fk_hospitalisation_patient_id; Type: FK CONSTRAINT; Schema: patient; Owner: gecamed
--

ALTER TABLE ONLY hospitalisation
    ADD CONSTRAINT fk_hospitalisation_patient_id FOREIGN KEY (patient_id) REFERENCES patient(id) ON DELETE CASCADE;


--
-- TOC entry 3493 (class 2606 OID 17023)
-- Dependencies: 271 3214 263
-- Name: fk_hospitalisation_period_hospital_department_id; Type: FK CONSTRAINT; Schema: patient; Owner: gecamed
--

ALTER TABLE ONLY hospitalisation_period
    ADD CONSTRAINT fk_hospitalisation_period_hospital_department_id FOREIGN KEY (hospital_department_id) REFERENCES hospital_department(id);


--
-- TOC entry 3495 (class 2606 OID 17013)
-- Dependencies: 265 271 3216
-- Name: fk_hospitalisation_period_hospitalisation_class_id; Type: FK CONSTRAINT; Schema: patient; Owner: gecamed
--

ALTER TABLE ONLY hospitalisation_period
    ADD CONSTRAINT fk_hospitalisation_period_hospitalisation_class_id FOREIGN KEY (hospitalisation_class_id) REFERENCES hospitalisation_class(id);


--
-- TOC entry 3494 (class 2606 OID 17018)
-- Dependencies: 3220 269 271
-- Name: fk_hospitalisation_period_hospitalisation_id; Type: FK CONSTRAINT; Schema: patient; Owner: gecamed
--

ALTER TABLE ONLY hospitalisation_period
    ADD CONSTRAINT fk_hospitalisation_period_hospitalisation_id FOREIGN KEY (hospitalisation_id) REFERENCES hospitalisation(id) ON DELETE CASCADE;


--
-- TOC entry 3496 (class 2606 OID 17008)
-- Dependencies: 271 3218 267
-- Name: fk_hospitalisation_period_hospitalisation_status_id; Type: FK CONSTRAINT; Schema: patient; Owner: gecamed
--

ALTER TABLE ONLY hospitalisation_period
    ADD CONSTRAINT fk_hospitalisation_period_hospitalisation_status_id FOREIGN KEY (hospitalisation_status_id) REFERENCES hospitalisation_status(id);


--
-- TOC entry 3528 (class 2606 OID 17294)
-- Dependencies: 301 297 3273
-- Name: fk_incident_entry_incident; Type: FK CONSTRAINT; Schema: patient; Owner: gecamed
--

ALTER TABLE ONLY incident_entry
    ADD CONSTRAINT fk_incident_entry_incident FOREIGN KEY (incident_id) REFERENCES incidents(id) ON DELETE CASCADE;


--
-- TOC entry 3526 (class 2606 OID 17304)
-- Dependencies: 3169 229 301
-- Name: fk_incident_entry_modified; Type: FK CONSTRAINT; Schema: patient; Owner: gecamed
--

ALTER TABLE ONLY incident_entry
    ADD CONSTRAINT fk_incident_entry_modified FOREIGN KEY (modified_by) REFERENCES usermanagement.gecamed_user(id);


--
-- TOC entry 3529 (class 2606 OID 17289)
-- Dependencies: 301 299 3275
-- Name: fk_incident_entry_type; Type: FK CONSTRAINT; Schema: patient; Owner: gecamed
--

ALTER TABLE ONLY incident_entry
    ADD CONSTRAINT fk_incident_entry_type FOREIGN KEY (entry_type_id) REFERENCES incident_entry_types(id);


--
-- TOC entry 3527 (class 2606 OID 17299)
-- Dependencies: 229 3169 301
-- Name: fk_incident_entry_user; Type: FK CONSTRAINT; Schema: patient; Owner: gecamed
--

ALTER TABLE ONLY incident_entry
    ADD CONSTRAINT fk_incident_entry_user FOREIGN KEY (created_by) REFERENCES usermanagement.gecamed_user(id);


--
-- TOC entry 3525 (class 2606 OID 17252)
-- Dependencies: 257 3206 297
-- Name: fk_incident_patient; Type: FK CONSTRAINT; Schema: patient; Owner: gecamed
--

ALTER TABLE ONLY incidents
    ADD CONSTRAINT fk_incident_patient FOREIGN KEY (patient_id) REFERENCES patient(id) ON DELETE CASCADE;


--
-- TOC entry 3524 (class 2606 OID 17257)
-- Dependencies: 247 297 3189
-- Name: fk_incident_physician; Type: FK CONSTRAINT; Schema: patient; Owner: gecamed
--

ALTER TABLE ONLY incidents
    ADD CONSTRAINT fk_incident_physician FOREIGN KEY (physician_id) REFERENCES office.physician(id) ON DELETE CASCADE;


--
-- TOC entry 3523 (class 2606 OID 17262)
-- Dependencies: 3193 297 251
-- Name: fk_incident_site_id; Type: FK CONSTRAINT; Schema: patient; Owner: gecamed
--

ALTER TABLE ONLY incidents
    ADD CONSTRAINT fk_incident_site_id FOREIGN KEY (site_id) REFERENCES office.site(id);


--
-- TOC entry 3486 (class 2606 OID 16897)
-- Dependencies: 255 253 3195
-- Name: fk_insurance_plan_insurance_id; Type: FK CONSTRAINT; Schema: patient; Owner: gecamed
--

ALTER TABLE ONLY insurance_plan
    ADD CONSTRAINT fk_insurance_plan_insurance_id FOREIGN KEY (insurance_id) REFERENCES insurance(id);


--
-- TOC entry 3531 (class 2606 OID 17332)
-- Dependencies: 301 3278 305
-- Name: fk_measurement_entry; Type: FK CONSTRAINT; Schema: patient; Owner: gecamed
--

ALTER TABLE ONLY measurement_values
    ADD CONSTRAINT fk_measurement_entry FOREIGN KEY (incident_entry_id) REFERENCES incident_entry(id) ON DELETE CASCADE;


--
-- TOC entry 3532 (class 2606 OID 17327)
-- Dependencies: 297 305 3273
-- Name: fk_measurement_v_incident; Type: FK CONSTRAINT; Schema: patient; Owner: gecamed
--

ALTER TABLE ONLY measurement_values
    ADD CONSTRAINT fk_measurement_v_incident FOREIGN KEY (incident_id) REFERENCES incidents(id) ON DELETE CASCADE;


--
-- TOC entry 3530 (class 2606 OID 17393)
-- Dependencies: 305 303 3280
-- Name: fk_measurement_values_measurement_types; Type: FK CONSTRAINT; Schema: patient; Owner: gecamed
--

ALTER TABLE ONLY measurement_values
    ADD CONSTRAINT fk_measurement_values_measurement_types FOREIGN KEY (measurement_types_id) REFERENCES measurement_types(id);


--
-- TOC entry 3501 (class 2606 OID 17103)
-- Dependencies: 3169 279 229
-- Name: fk_passage_created_by; Type: FK CONSTRAINT; Schema: patient; Owner: gecamed
--

ALTER TABLE ONLY passage
    ADD CONSTRAINT fk_passage_created_by FOREIGN KEY (created_by) REFERENCES usermanagement.gecamed_user(id);


--
-- TOC entry 3500 (class 2606 OID 17108)
-- Dependencies: 279 3228 273
-- Name: fk_passage_hospital_prescription; Type: FK CONSTRAINT; Schema: patient; Owner: gecamed
--

ALTER TABLE ONLY passage
    ADD CONSTRAINT fk_passage_hospital_prescription FOREIGN KEY (hospprescription_id) REFERENCES hospital_prescription(id) ON DELETE SET NULL;


--
-- TOC entry 3502 (class 2606 OID 17098)
-- Dependencies: 279 247 3189
-- Name: fk_passage_physician; Type: FK CONSTRAINT; Schema: patient; Owner: gecamed
--

ALTER TABLE ONLY passage
    ADD CONSTRAINT fk_passage_physician FOREIGN KEY (physician_id) REFERENCES office.physician(id);


--
-- TOC entry 3488 (class 2606 OID 16918)
-- Dependencies: 255 257 3197
-- Name: fk_patient_complementary_id; Type: FK CONSTRAINT; Schema: patient; Owner: gecamed
--

ALTER TABLE ONLY patient
    ADD CONSTRAINT fk_patient_complementary_id FOREIGN KEY (complementary_id) REFERENCES insurance_plan(id);


--
-- TOC entry 3508 (class 2606 OID 17140)
-- Dependencies: 257 283 3206
-- Name: fk_patient_contact_id; Type: FK CONSTRAINT; Schema: patient; Owner: gecamed
--

ALTER TABLE ONLY patient_contact
    ADD CONSTRAINT fk_patient_contact_id FOREIGN KEY (patient_id) REFERENCES patient(id) ON DELETE CASCADE;


--
-- TOC entry 3507 (class 2606 OID 17145)
-- Dependencies: 3152 217 283
-- Name: fk_patient_contact_locality_id; Type: FK CONSTRAINT; Schema: patient; Owner: gecamed
--

ALTER TABLE ONLY patient_contact
    ADD CONSTRAINT fk_patient_contact_locality_id FOREIGN KEY (locality_id) REFERENCES address.locality(id);


--
-- TOC entry 3533 (class 2606 OID 17398)
-- Dependencies: 3206 307 257
-- Name: fk_patient_datas_patient; Type: FK CONSTRAINT; Schema: patient; Owner: gecamed
--

ALTER TABLE ONLY patient_datas
    ADD CONSTRAINT fk_patient_datas_patient FOREIGN KEY (patient_id) REFERENCES patient(id) ON DELETE CASCADE;


--
-- TOC entry 3490 (class 2606 OID 16941)
-- Dependencies: 259 257 3206
-- Name: fk_patient_foto_patient_id; Type: FK CONSTRAINT; Schema: patient; Owner: gecamed
--

ALTER TABLE ONLY patient_foto
    ADD CONSTRAINT fk_patient_foto_patient_id FOREIGN KEY (patient_id) REFERENCES patient(id) ON DELETE CASCADE;


--
-- TOC entry 3489 (class 2606 OID 16913)
-- Dependencies: 3195 253 257
-- Name: fk_patient_insurance_id; Type: FK CONSTRAINT; Schema: patient; Owner: gecamed
--

ALTER TABLE ONLY patient
    ADD CONSTRAINT fk_patient_insurance_id FOREIGN KEY (insurance_id) REFERENCES insurance(id);


--
-- TOC entry 3511 (class 2606 OID 17185)
-- Dependencies: 3169 229 287
-- Name: fk_patient_memo_author; Type: FK CONSTRAINT; Schema: patient; Owner: gecamed
--

ALTER TABLE ONLY patient_memo
    ADD CONSTRAINT fk_patient_memo_author FOREIGN KEY (author_id) REFERENCES usermanagement.gecamed_user(id);


--
-- TOC entry 3512 (class 2606 OID 17180)
-- Dependencies: 3206 257 287
-- Name: fk_patient_memo_patient; Type: FK CONSTRAINT; Schema: patient; Owner: gecamed
--

ALTER TABLE ONLY patient_memo
    ADD CONSTRAINT fk_patient_memo_patient FOREIGN KEY (patient_id) REFERENCES patient(id) ON DELETE CASCADE;


--
-- TOC entry 3491 (class 2606 OID 16954)
-- Dependencies: 261 257 3206
-- Name: fk_patient_phone_patient_id; Type: FK CONSTRAINT; Schema: patient; Owner: gecamed
--

ALTER TABLE ONLY patient_phone
    ADD CONSTRAINT fk_patient_phone_patient_id FOREIGN KEY (patient_id) REFERENCES patient(id) ON DELETE CASCADE;


--
-- TOC entry 3509 (class 2606 OID 17161)
-- Dependencies: 257 3206 285
-- Name: fk_patient_relation_child; Type: FK CONSTRAINT; Schema: patient; Owner: gecamed
--

ALTER TABLE ONLY patient_relation
    ADD CONSTRAINT fk_patient_relation_child FOREIGN KEY (child_id) REFERENCES patient(id) ON DELETE CASCADE;


--
-- TOC entry 3510 (class 2606 OID 17156)
-- Dependencies: 285 3206 257
-- Name: fk_patient_relation_parent; Type: FK CONSTRAINT; Schema: patient; Owner: gecamed
--

ALTER TABLE ONLY patient_relation
    ADD CONSTRAINT fk_patient_relation_parent FOREIGN KEY (parent_id) REFERENCES patient(id) ON DELETE CASCADE;


--
-- TOC entry 3487 (class 2606 OID 16923)
-- Dependencies: 257 257 3206
-- Name: fk_patient_spouse_id; Type: FK CONSTRAINT; Schema: patient; Owner: gecamed
--

ALTER TABLE ONLY patient
    ADD CONSTRAINT fk_patient_spouse_id FOREIGN KEY (spouse_id) REFERENCES patient(id);


--
-- TOC entry 3522 (class 2606 OID 17383)
-- Dependencies: 3273 295 297
-- Name: fk_visit_relations_visits_child; Type: FK CONSTRAINT; Schema: patient; Owner: gecamed
--

ALTER TABLE ONLY incident_relations
    ADD CONSTRAINT fk_visit_relations_visits_child FOREIGN KEY (child_incident_id) REFERENCES incidents(id);


--
-- TOC entry 3521 (class 2606 OID 17388)
-- Dependencies: 297 3273 295
-- Name: fk_visit_relations_visits_parent; Type: FK CONSTRAINT; Schema: patient; Owner: gecamed
--

ALTER TABLE ONLY incident_relations
    ADD CONSTRAINT fk_visit_relations_visits_parent FOREIGN KEY (parent_incident_id) REFERENCES incidents(id);


--
-- TOC entry 3519 (class 2606 OID 17373)
-- Dependencies: 3169 293 229
-- Name: fk_visits_gecamed_user_created; Type: FK CONSTRAINT; Schema: patient; Owner: gecamed
--

ALTER TABLE ONLY consultations
    ADD CONSTRAINT fk_visits_gecamed_user_created FOREIGN KEY (created_by) REFERENCES usermanagement.gecamed_user(id);


--
-- TOC entry 3518 (class 2606 OID 17378)
-- Dependencies: 3169 293 229
-- Name: fk_visits_gecamed_user_modified; Type: FK CONSTRAINT; Schema: patient; Owner: gecamed
--

ALTER TABLE ONLY consultations
    ADD CONSTRAINT fk_visits_gecamed_user_modified FOREIGN KEY (modified_by) REFERENCES usermanagement.gecamed_user(id);


--
-- TOC entry 3503 (class 2606 OID 17093)
-- Dependencies: 3225 271 279
-- Name: fkpassage_hospitalisationperiod; Type: FK CONSTRAINT; Schema: patient; Owner: gecamed
--

ALTER TABLE ONLY passage
    ADD CONSTRAINT fkpassage_hospitalisationperiod FOREIGN KEY (hospperiod_id) REFERENCES hospitalisation_period(id) ON DELETE CASCADE;


--
-- TOC entry 3504 (class 2606 OID 17088)
-- Dependencies: 3206 257 279
-- Name: fkpassage_patient; Type: FK CONSTRAINT; Schema: patient; Owner: gecamed
--

ALTER TABLE ONLY passage
    ADD CONSTRAINT fkpassage_patient FOREIGN KEY (patient_id) REFERENCES patient(id) ON DELETE CASCADE;


SET search_path = prescription, pg_catalog;

--
-- TOC entry 3545 (class 2606 OID 17605)
-- Dependencies: 3309 329 329
-- Name: fk_cefip_atc_parent; Type: FK CONSTRAINT; Schema: prescription; Owner: gecamed
--

ALTER TABLE ONLY cefip_atc_classes
    ADD CONSTRAINT fk_cefip_atc_parent FOREIGN KEY (parent) REFERENCES cefip_atc_classes(id) ON DELETE CASCADE;


--
-- TOC entry 3548 (class 2606 OID 17672)
-- Dependencies: 3320 336 338
-- Name: fk_presc_drug_rev_presc; Type: FK CONSTRAINT; Schema: prescription; Owner: gecamed
--

ALTER TABLE ONLY prescription_drug_revisions
    ADD CONSTRAINT fk_presc_drug_rev_presc FOREIGN KEY (prescription_rev_id) REFERENCES prescription_revisions(id) ON DELETE CASCADE;


--
-- TOC entry 3534 (class 2606 OID 17557)
-- Dependencies: 317 3300 321
-- Name: fk_prescription_drugs_prescriptions; Type: FK CONSTRAINT; Schema: prescription; Owner: gecamed
--

ALTER TABLE ONLY prescription_drugs
    ADD CONSTRAINT fk_prescription_drugs_prescriptions FOREIGN KEY (prescriptions_id) REFERENCES prescriptions(id) ON DELETE CASCADE;


--
-- TOC entry 3538 (class 2606 OID 17562)
-- Dependencies: 229 3169 321
-- Name: fk_prescription_gecamed_user; Type: FK CONSTRAINT; Schema: prescription; Owner: gecamed
--

ALTER TABLE ONLY prescriptions
    ADD CONSTRAINT fk_prescription_gecamed_user FOREIGN KEY (created_by) REFERENCES usermanagement.gecamed_user(id);


--
-- TOC entry 3537 (class 2606 OID 17567)
-- Dependencies: 3189 321 247
-- Name: fk_prescription_physician; Type: FK CONSTRAINT; Schema: prescription; Owner: gecamed
--

ALTER TABLE ONLY prescriptions
    ADD CONSTRAINT fk_prescription_physician FOREIGN KEY (physician_id) REFERENCES office.physician(id);


--
-- TOC entry 3536 (class 2606 OID 17572)
-- Dependencies: 319 321 3297
-- Name: fk_prescription_prescription_types; Type: FK CONSTRAINT; Schema: prescription; Owner: gecamed
--

ALTER TABLE ONLY prescriptions
    ADD CONSTRAINT fk_prescription_prescription_types FOREIGN KEY (prescription_types_id) REFERENCES prescription_types(id);


--
-- TOC entry 3550 (class 2606 OID 17692)
-- Dependencies: 3169 229 338
-- Name: fk_prescription_rev_gecamed_user; Type: FK CONSTRAINT; Schema: prescription; Owner: gecamed
--

ALTER TABLE ONLY prescription_revisions
    ADD CONSTRAINT fk_prescription_rev_gecamed_user FOREIGN KEY (created_by) REFERENCES usermanagement.gecamed_user(id);


--
-- TOC entry 3552 (class 2606 OID 17682)
-- Dependencies: 338 3189 247
-- Name: fk_prescription_rev_physician; Type: FK CONSTRAINT; Schema: prescription; Owner: gecamed
--

ALTER TABLE ONLY prescription_revisions
    ADD CONSTRAINT fk_prescription_rev_physician FOREIGN KEY (physician_id) REFERENCES office.physician(id);


--
-- TOC entry 3553 (class 2606 OID 17677)
-- Dependencies: 3297 338 319
-- Name: fk_prescription_rev_prescription_types; Type: FK CONSTRAINT; Schema: prescription; Owner: gecamed
--

ALTER TABLE ONLY prescription_revisions
    ADD CONSTRAINT fk_prescription_rev_prescription_types FOREIGN KEY (prescription_types_id) REFERENCES prescription_types(id);


--
-- TOC entry 3551 (class 2606 OID 17687)
-- Dependencies: 3273 297 338
-- Name: fk_prescription_rev_visits; Type: FK CONSTRAINT; Schema: prescription; Owner: gecamed
--

ALTER TABLE ONLY prescription_revisions
    ADD CONSTRAINT fk_prescription_rev_visits FOREIGN KEY (incident_id) REFERENCES patient.incidents(id) ON DELETE CASCADE;


--
-- TOC entry 3554 (class 2606 OID 17667)
-- Dependencies: 321 338 3300
-- Name: fk_prescription_revision; Type: FK CONSTRAINT; Schema: prescription; Owner: gecamed
--

ALTER TABLE ONLY prescription_revisions
    ADD CONSTRAINT fk_prescription_revision FOREIGN KEY (prescription_id) REFERENCES prescriptions(id) ON DELETE CASCADE;


--
-- TOC entry 3535 (class 2606 OID 17702)
-- Dependencies: 297 3273 321
-- Name: fk_prescription_visits; Type: FK CONSTRAINT; Schema: prescription; Owner: gecamed
--

ALTER TABLE ONLY prescriptions
    ADD CONSTRAINT fk_prescription_visits FOREIGN KEY (incident_id) REFERENCES patient.incidents(id) ON DELETE SET NULL;


--
-- TOC entry 3539 (class 2606 OID 17510)
-- Dependencies: 301 3278 321
-- Name: fk_prescritpion_entry; Type: FK CONSTRAINT; Schema: prescription; Owner: gecamed
--

ALTER TABLE ONLY prescriptions
    ADD CONSTRAINT fk_prescritpion_entry FOREIGN KEY (incident_entry_id) REFERENCES patient.incident_entry(id) ON DELETE CASCADE;


--
-- TOC entry 3549 (class 2606 OID 17697)
-- Dependencies: 3278 301 338
-- Name: fk_prescritpion_revi_entry; Type: FK CONSTRAINT; Schema: prescription; Owner: gecamed
--

ALTER TABLE ONLY prescription_revisions
    ADD CONSTRAINT fk_prescritpion_revi_entry FOREIGN KEY (incident_entry_id) REFERENCES patient.incident_entry(id) ON DELETE CASCADE;


--
-- TOC entry 3543 (class 2606 OID 17552)
-- Dependencies: 229 327 3169
-- Name: fk_print_prescription_gecameduser; Type: FK CONSTRAINT; Schema: prescription; Owner: gecamed
--

ALTER TABLE ONLY print_prescription
    ADD CONSTRAINT fk_print_prescription_gecameduser FOREIGN KEY (printed_by_id) REFERENCES usermanagement.gecamed_user(id) ON DELETE CASCADE;


--
-- TOC entry 3544 (class 2606 OID 17547)
-- Dependencies: 3300 327 321
-- Name: fk_print_prescription_prescriptions; Type: FK CONSTRAINT; Schema: prescription; Owner: gecamed
--

ALTER TABLE ONLY print_prescription
    ADD CONSTRAINT fk_print_prescription_prescriptions FOREIGN KEY (prescription_id) REFERENCES prescriptions(id) ON DELETE CASCADE;


--
-- TOC entry 3546 (class 2606 OID 17639)
-- Dependencies: 329 334 3309
-- Name: fk_rel_cefip_atc_atc_id; Type: FK CONSTRAINT; Schema: prescription; Owner: gecamed
--

ALTER TABLE ONLY rel_cefip_drugs_atc_classes
    ADD CONSTRAINT fk_rel_cefip_atc_atc_id FOREIGN KEY (atc_id) REFERENCES cefip_atc_classes(id) ON DELETE CASCADE;


--
-- TOC entry 3547 (class 2606 OID 17634)
-- Dependencies: 331 334 3311
-- Name: fk_rel_cefip_atc_drug_id; Type: FK CONSTRAINT; Schema: prescription; Owner: gecamed
--

ALTER TABLE ONLY rel_cefip_drugs_atc_classes
    ADD CONSTRAINT fk_rel_cefip_atc_drug_id FOREIGN KEY (cefip_drug_id) REFERENCES cefip_drugs(id) ON DELETE CASCADE;


--
-- TOC entry 3540 (class 2606 OID 17582)
-- Dependencies: 3304 325 323
-- Name: fk_template_drugs_templates; Type: FK CONSTRAINT; Schema: prescription; Owner: gecamed
--

ALTER TABLE ONLY template_drugs
    ADD CONSTRAINT fk_template_drugs_templates FOREIGN KEY (template_id) REFERENCES templates(id) ON DELETE CASCADE;


--
-- TOC entry 3542 (class 2606 OID 17587)
-- Dependencies: 229 3169 325
-- Name: fk_templates_gecamed_user_created; Type: FK CONSTRAINT; Schema: prescription; Owner: gecamed
--

ALTER TABLE ONLY templates
    ADD CONSTRAINT fk_templates_gecamed_user_created FOREIGN KEY (owner_id) REFERENCES usermanagement.gecamed_user(id);


--
-- TOC entry 3541 (class 2606 OID 17592)
-- Dependencies: 325 3297 319
-- Name: fk_templates_prescription_types; Type: FK CONSTRAINT; Schema: prescription; Owner: gecamed
--

ALTER TABLE ONLY templates
    ADD CONSTRAINT fk_templates_prescription_types FOREIGN KEY (prescription_types_id) REFERENCES prescription_types(id);


SET search_path = usermanagement, pg_catalog;

--
-- TOC entry 3476 (class 2606 OID 16759)
-- Dependencies: 229 3169 237
-- Name: fk_message_receiver_id; Type: FK CONSTRAINT; Schema: usermanagement; Owner: gecamed
--

ALTER TABLE ONLY message
    ADD CONSTRAINT fk_message_receiver_id FOREIGN KEY (receiver_id) REFERENCES gecamed_user(id);


--
-- TOC entry 3477 (class 2606 OID 16754)
-- Dependencies: 3169 237 229
-- Name: fk_message_sender_id; Type: FK CONSTRAINT; Schema: usermanagement; Owner: gecamed
--

ALTER TABLE ONLY message
    ADD CONSTRAINT fk_message_sender_id FOREIGN KEY (sender_id) REFERENCES gecamed_user(id);


--
-- TOC entry 3470 (class 2606 OID 16662)
-- Dependencies: 3162 227 225
-- Name: fk_rel_role_permission_role_id; Type: FK CONSTRAINT; Schema: usermanagement; Owner: gecamed
--

ALTER TABLE ONLY rel_role_permission
    ADD CONSTRAINT fk_rel_role_permission_role_id FOREIGN KEY (role_id) REFERENCES role(id) ON DELETE CASCADE;


--
-- TOC entry 3472 (class 2606 OID 16715)
-- Dependencies: 233 3158 223
-- Name: fk_rel_user_permission_permission_id; Type: FK CONSTRAINT; Schema: usermanagement; Owner: gecamed
--

ALTER TABLE ONLY rel_user_permission
    ADD CONSTRAINT fk_rel_user_permission_permission_id FOREIGN KEY (permission_id) REFERENCES permission(id) ON DELETE CASCADE;


--
-- TOC entry 3473 (class 2606 OID 16710)
-- Dependencies: 3169 229 233
-- Name: fk_rel_user_permission_user_id; Type: FK CONSTRAINT; Schema: usermanagement; Owner: gecamed
--

ALTER TABLE ONLY rel_user_permission
    ADD CONSTRAINT fk_rel_user_permission_user_id FOREIGN KEY (user_id) REFERENCES gecamed_user(id) ON DELETE CASCADE;


--
-- TOC entry 3474 (class 2606 OID 16734)
-- Dependencies: 3162 225 235
-- Name: fk_rel_user_role_role_id; Type: FK CONSTRAINT; Schema: usermanagement; Owner: gecamed
--

ALTER TABLE ONLY rel_user_role
    ADD CONSTRAINT fk_rel_user_role_role_id FOREIGN KEY (role_id) REFERENCES role(id) ON DELETE CASCADE;


--
-- TOC entry 3475 (class 2606 OID 16729)
-- Dependencies: 3169 229 235
-- Name: fk_rel_user_role_user_id; Type: FK CONSTRAINT; Schema: usermanagement; Owner: gecamed
--

ALTER TABLE ONLY rel_user_role
    ADD CONSTRAINT fk_rel_user_role_user_id FOREIGN KEY (user_id) REFERENCES gecamed_user(id) ON DELETE CASCADE;


--
-- TOC entry 3469 (class 2606 OID 16667)
-- Dependencies: 223 3158 227
-- Name: fk_role_permission_permission_id; Type: FK CONSTRAINT; Schema: usermanagement; Owner: gecamed
--

ALTER TABLE ONLY rel_role_permission
    ADD CONSTRAINT fk_role_permission_permission_id FOREIGN KEY (permission_id) REFERENCES permission(id) ON DELETE CASCADE;


--
-- TOC entry 3471 (class 2606 OID 16681)
-- Dependencies: 229 3119 185
-- Name: fk_usermanagement_gecamed_user_locale; Type: FK CONSTRAINT; Schema: usermanagement; Owner: gecamed
--

ALTER TABLE ONLY gecamed_user
    ADD CONSTRAINT fk_usermanagement_gecamed_user_locale FOREIGN KEY (locale_id) REFERENCES core.locale(id);


SET search_path = waitingroom, pg_catalog;

--
-- TOC entry 3646 (class 2606 OID 18727)
-- Dependencies: 257 440 3206
-- Name: fk_queue_patientid; Type: FK CONSTRAINT; Schema: waitingroom; Owner: gecamed
--

ALTER TABLE ONLY queue
    ADD CONSTRAINT fk_queue_patientid FOREIGN KEY (patient_id) REFERENCES patient.patient(id) ON DELETE CASCADE;


--
-- TOC entry 3643 (class 2606 OID 18742)
-- Dependencies: 440 247 3189
-- Name: fk_queue_physician_id; Type: FK CONSTRAINT; Schema: waitingroom; Owner: gecamed
--

ALTER TABLE ONLY queue
    ADD CONSTRAINT fk_queue_physician_id FOREIGN KEY (physician_id) REFERENCES office.physician(id);


--
-- TOC entry 3645 (class 2606 OID 18732)
-- Dependencies: 440 438 3443
-- Name: fk_queue_room_id; Type: FK CONSTRAINT; Schema: waitingroom; Owner: gecamed
--

ALTER TABLE ONLY queue
    ADD CONSTRAINT fk_queue_room_id FOREIGN KEY (room_id) REFERENCES room(id) ON DELETE CASCADE;


--
-- TOC entry 3644 (class 2606 OID 18737)
-- Dependencies: 3169 229 440
-- Name: fk_queue_user_id; Type: FK CONSTRAINT; Schema: waitingroom; Owner: gecamed
--

ALTER TABLE ONLY queue
    ADD CONSTRAINT fk_queue_user_id FOREIGN KEY (created_by) REFERENCES usermanagement.gecamed_user(id);


--
-- TOC entry 3642 (class 2606 OID 18747)
-- Dependencies: 438 251 3193
-- Name: fk_room_site_id; Type: FK CONSTRAINT; Schema: waitingroom; Owner: gecamed
--

ALTER TABLE ONLY room
    ADD CONSTRAINT fk_room_site_id FOREIGN KEY (site_id) REFERENCES office.site(id) ON DELETE SET NULL;

